//----------------------------------------------------------------------------
//   The confidential and proprietary information contained in this file may
//   only be used by a person authorised under and to the extent permitted
//   by a subsisting licensing agreement from ARM Limited or its affiliates.
//
//          (C) COPYRIGHT 2017 ARM Limited or its affiliates.
//              ALL RIGHTS RESERVED
//
//   This entire notice must be reproduced on all copies of this file
//   and copies of this file may only be made by a person if such person is
//   permitted to do so under the terms of a subsisting license agreement
//   from ARM Limited or its affiliates.
//----------------------------------------------------------------------------
var express = require('express');
var fs = require('fs');
var router = express.Router();
var events = require('events'); // jshint ignore:line
var runScrTemplate = require('./template');
var path = require('path');
var pkg = require('./package.json');


router.get('/', function(req, res) {
    var html = fs.readFileSync(__dirname + '/static/html/index.html','utf8');
    html = html.replace('@@VERSION', pkg.version);
    res.send(html);
});


function toTypedArray(buffer) {
    var ab = new ArrayBuffer(buffer.length);
    var view = new Uint8Array(ab);
    for (var i = 0; i < buffer.length; ++i) {
        view[i] = buffer[i];
    }
    return view;
}


function toBuffer(ab) {
    var buffer = new Buffer(ab.byteLength);
    var view = new Uint8Array(ab);
    for (var i = 0; i < buffer.length; ++i) {
        buffer[i] = view[i];
    }
    return buffer;
}

function checkForCustomData(layout, index, callback) {
    if (layout.transformations[index]) {
        if (layout.transformations[index].transformation === 'Custom') {
            var filename = 'config' + index + '.txt';
            fs.writeFile('./libraries/libapical-gdc/' + filename, layout.transformations[index].data, function(err) {
                delete layout.transformations[index].data;
                layout.transformations[index].param = {};
                layout.transformations[index].param.customTransformation = '../libapical-gdc/' + filename;
                index++;
                checkForCustomData(layout, index, callback);
            });
        } else {
            index++;
            checkForCustomData(layout, index, callback);
        }
    } else {
        callback(layout);
    }
}

router.post('/transform-image', function(req, res) {
    var body = [];
    var totalLength = 0;
    req.on('data', function (chunk) {
        totalLength += chunk.length;
        body.push(chunk);
    });
    req.on('end', function() {
        var typedArray = toTypedArray(Buffer.concat(body));
        var sixth = typedArray.length / 6;
        var yData = typedArray.slice(0, sixth * 4);
        var uData = typedArray.slice(sixth * 4, sixth * 5);
        var vData = typedArray.slice(sixth * 5, typedArray.length);

        fs.writeFile('./libraries/libapical-gdc/Y.bin', toBuffer(yData.buffer), (err) => {
            if (err) {
                throw err;
            }
            fs.writeFile('./libraries/libapical-gdc/U.bin', toBuffer(uData.buffer), (err) => {
            if (err) {
                throw err;
            }
            fs.writeFile('./libraries/libapical-gdc/V.bin', toBuffer(vData.buffer), (err) => {
                if (err) {
                    throw err;
                }
                    var settings = JSON.parse(fs.readFileSync('./libraries/libgdc/scene.json', 'utf8'));

                    var inputWidth = settings['inputRes'][0];
                    var inputHeight = settings['inputRes'][1];

                    var outputWidth = settings['outputRes'][0];
                    var outputHeight = settings['outputRes'][1];

                    var stats = fs.statSync('./libraries/libapical-gdc/config.bin');
                    var configSize = (stats["size"]/4).toString(16);
                    var runscr = runScrTemplate.generate('yuvPlanar', configSize, inputWidth, inputHeight, outputWidth, outputHeight);

                    fs.writeFile('./libraries/libapical-gdc/run.scr', runscr, (err) => {
                        if (err) {
                            throw err;
                        }
                        var exec = require('child_process').exec;
                        var gdcPath = path.join(__dirname, '/libraries/libapical-gdc/gdc');
                        var inputPath = path.join( __dirname, '/libraries/libapical-gdc/run.scr');
                        var outputPath = path.join(__dirname, '/libraries/libapical-gdc/output.txt');
                        var cwdPath = path.join(__dirname, '/libraries/libapical-gdc');
                        console.log(gdcPath + ' -i ' + inputPath + ' -o ' + outputPath);
                        exec(gdcPath + ' -i ' + inputPath + ' -o ' + outputPath, {cwd: cwdPath}, function(err, stdout) {
                            fs.readFile('./libraries/libapical-gdc/out_Y.bin', function (err, yData) {
                                if (err) {
                                    console.log('native process error: ' + err);
                                    res.status(500);
                                    res.send('native process error code: ' + err.code);
                                } else {
                                    fs.readFile('./libraries/libapical-gdc/out_U.bin', function (err, uData) {
                                        if (err) {
                                            throw err;
                                        }
                                        fs.readFile('./libraries/libapical-gdc/out_V.bin', function (err, vData) {
                                            var yArray = toTypedArray(yData);
                                            var uArray = toTypedArray(uData);
                                            var vArray = toTypedArray(vData);
                                            var newUMatrix = [];
                                            var newVMatrix = [];
                                            var uTemp, vTemp;
                                            var uVal, vVal;
                                            for (var i = 0; i < (outputHeight / 2); i++) {
                                                uTemp = [];
                                                vTemp = [];
                                                for (var j = 0; j < (outputWidth / 2); j++) {
                                                    uVal = uArray[j + (i * (outputWidth / 2))];
                                                    vVal = vArray[j + (i * (outputWidth / 2))];
                                                    uTemp.push(uVal, uVal);
                                                    vTemp.push(vVal, vVal);
                                                }
                                                newUMatrix.push(uTemp, uTemp);
                                                newVMatrix.push(vTemp, vTemp);
                                            }

                                            var newUArray = Uint8Array.from([].concat.apply([], newUMatrix));
                                            var newVArray = Uint8Array.from([].concat.apply([], newVMatrix));

                                            if (err) {
                                                throw err;
                                            }
                                            var yuvData = new Uint8Array(yArray.length + newUArray.length + newVArray.length);
                                            yuvData.set(yArray, 0);
                                            yuvData.set(newUArray, yArray.length);
                                            yuvData.set(newVArray, yArray.length + newUArray.length);
                                            var buff = toBuffer(yuvData.buffer);
                                            res.status(200);
                                            res.setHeader('Content-Type', 'application/octet-stream');
                                            res.end(buff);
                                        });
                                    });
                                }
                            });
                        });
                    });
                });
            });
        });
    });
});

router.post('/transform-semiplanar-image', function(req, res) {
    var body = [];
    var totalLength = 0;
    req.on('data', function (chunk) {
        totalLength += chunk.length;
        body.push(chunk);
    });
    req.on('end', function() {
        var typedArray = toTypedArray(Buffer.concat(body));
        var sixth = typedArray.length / 6;
        var yData = typedArray.slice(0, sixth * 4);
        var uData = typedArray.slice(sixth * 4, sixth * 5);
        var vData = typedArray.slice(sixth * 5, typedArray.length);
        var uvDataBuffer = new ArrayBuffer(uData.length + vData.length);
        var uvData = new Uint8Array(uvDataBuffer);
        for (var i = 0; i < uData.length; i++) {
            uvData[i * 2] = uData[i];
            uvData[(i * 2) + 1] = vData[i];
        }

        fs.writeFile('./libraries/libapical-gdc/Y.bin', toBuffer(yData.buffer), (err) => {
            if (err) {
                throw err;
            }
            fs.writeFile('./libraries/libapical-gdc/UV.bin', toBuffer(uvData.buffer), (err) => {
            if (err) {
                throw err;
            }
                var settings = JSON.parse(fs.readFileSync('./libraries/libgdc/scene.json', 'utf8'));

                var inputWidth = settings['inputRes'][0];
                var inputHeight = settings['inputRes'][1];

                var outputWidth = settings['outputRes'][0];
                var outputHeight = settings['outputRes'][1];

                var stats = fs.statSync('./libraries/libapical-gdc/config.bin');
                var configSize = (stats["size"]/4).toString(16);
                var runscr = runScrTemplate.generate('yuvSemiplanar', configSize, inputWidth, inputHeight, outputWidth, outputHeight);

                fs.writeFile('./libraries/libapical-gdc/run.scr', runscr, (err) => {
                    if (err) {
                        throw err;
                    }
                    var exec = require('child_process').exec;
                    var gdcPath = path.join(__dirname, '/libraries/libapical-gdc/gdc');
                    var inputPath = path.join( __dirname, '/libraries/libapical-gdc/run.scr');
                    var outputPath = path.join(__dirname, '/libraries/libapical-gdc/output.txt');
                    var cwdPath = path.join(__dirname, '/libraries/libapical-gdc');
                    exec(gdcPath + ' -i ' + inputPath + ' -o ' + outputPath, {cwd: cwdPath}, function(err, stdout) {
                        fs.readFile('./libraries/libapical-gdc/out_y.bin', function (err, yData) {
                            if (err) {
                                throw err;
                            }
                            fs.readFile('./libraries/libapical-gdc/out_uv.bin', function (err, uvData) {
                                if (err) {
                                    throw err;
                                }
                                var yArray = toTypedArray(yData);
                                var uvArray = toTypedArray(uvData);
                                var i;
                                var uArray = new Uint8Array(new Buffer(uvData.length/2));
                                var vArray = new Uint8Array(new Buffer(uvData.length/2));
                                for (i = 0; i < uvArray.length; i++) {
                                    uArray[i] = uvArray[i * 2];
                                    vArray[i] = uvArray[(i * 2) + 1];
                                }
                                var newUMatrix = [];
                                var newVMatrix = [];
                                var uTemp, vTemp;
                                var uVal, vVal;
                                for (i = 0; i < (outputHeight / 2); i++) {
                                    uTemp = [];
                                    vTemp = [];
                                    for (var j = 0; j < (outputWidth / 2); j++) {
                                        uVal = uArray[j + (i * (outputWidth / 2))];
                                        vVal = vArray[j + (i * (outputWidth / 2))];
                                        uTemp.push(uVal, uVal);
                                        vTemp.push(vVal, vVal);
                                    }
                                    newUMatrix.push(uTemp, uTemp);
                                    newVMatrix.push(vTemp, vTemp);
                                }

                                var newUArray = Uint8Array.from([].concat.apply([], newUMatrix));
                                var newVArray = Uint8Array.from([].concat.apply([], newVMatrix));

                                if (err) {
                                    throw err;
                                }
                                var yuvData = new Uint8Array(yArray.length + newUArray.length + newVArray.length);
                                yuvData.set(yArray, 0);
                                yuvData.set(newUArray, yArray.length);
                                yuvData.set(newVArray, yArray.length + newUArray.length);
                                var buff = toBuffer(yuvData.buffer);
                                res.status(200);
                                res.setHeader('Content-Type', 'application/octet-stream');
                                res.end(buff);
                            });
                        });
                    });
                });
            });
        });
    });
});


router.post('/generate-grid', function(req, res) {
    var data = '';
    req.on('data', function(chunk){
        data += chunk;
    });
    req.on('end', function(){
        var settings = JSON.parse(data);
        checkForCustomData(settings, 0, function(parsedSettings) {
            fs.writeFile("./libraries/libgdc/scene.json", JSON.stringify(parsedSettings, null, 4), function(err) {
                if (err) {
                    throw err;
                }
                var exec = require('child_process').exec;
                var url = __dirname + '/libraries/libgdc/gdc ' + __dirname + '/libraries/libgdc/scene.json ' + __dirname + '/libraries/libapical-gdc/config.bin';
                if (settings.mode === 'semi-planar') {
                    url += ' -s';
                }
                url += ' -g';
                exec(url, {cwd: __dirname + '/libraries/libgdc'}, function(err, stdout) {
                    if (err) {
                        console.log('native process error: ' + err);
                        res.status(500);
                        res.send('native process error code: ' + err.code);
                    } else {
                        res.status(200);
                        res.send(stdout);
                    }
                });
            });
        });
    });
});

router.post('/generate-binary', function(req, res) {
    var data = '';
    req.on('data', function(chunk){
        data += chunk;
    });
    req.on('end', function(){
        var settings = JSON.parse(data);
        for (var i = 0; i < settings.transformations.length; i++) {
            if (settings.transformations[i].transformation === 'Custom') {
                fs.writeFile("./libraries/libgdc/scene.json", settings.transformations[i].data, function(err) {
                    if (err) {
                        throw err;
                    }
                });
            }
        }
        delete settings.customSettingsData;

        fs.writeFile("./libraries/libgdc/scene.json", JSON.stringify(settings, null, 4), function(err) {
            if (err) {
                throw err;
            }
            var exec = require('child_process').exec;
            var url = __dirname + '/libraries/libgdc/gdc ' + __dirname + '/libraries/libgdc/scene.json ' + __dirname + '/libraries/libapical-gdc/config.bin';
            if (settings.mode === 'semi-planar') {
                url += ' -s';
            }
            try {
                exec(url, {cwd: __dirname + '/libraries/libgdc'}, function (err, stdout) {
                    if (err) {
                        console.log('native process error: ' + err);
                        res.status(500);
                        res.send('native process error code: ' + err.code);
                    } else {
                        var path = __dirname + '/libraries/libapical-gdc/config.bin';
                        res.setHeader('Content-disposition', 'attachment; filename=config.bin');
                        res.setHeader('Content-type', 'application/octet-stream');
                        var readStream = fs.createReadStream(path);
                        readStream.pipe(res);
                    }
                });
            } catch (err) {
                console.log('native process error: ' + err);
                res.status(500);
                res.send('native process error code: ' + err.code);
            }
        });
    });
});


router.post('/upload-custom-settings', function(req, res) {
    var newPath = __dirname + "/customSettings.json";
    var writeStream = fs.createWriteStream(newPath);
    req.pipe(writeStream);
    res.send('success');
});


module.exports = router;
