onmessage = function (e) {
    function clamp(n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return Math.floor(n);
    }

    let yuvData = new Uint8Array(e.data);
    let YArr = yuvData.slice(0, yuvData.length/3);
    let UArr = yuvData.slice(yuvData.length/3, (yuvData.length/3) * 2);
    let VArr = yuvData.slice((yuvData.length/3) * 2, yuvData.length);
    let RGBA = [];
    let i = 0;
    while (i < YArr.length) {
        RGBA.push(
            clamp((1.164 * (YArr[i] - 16)) + (1.596 * (VArr[i] - 128))),
            clamp((1.164 * (YArr[i] - 16)) - (0.392 * (UArr[i] - 128)) - (0.813 * (VArr[i] - 128))),
            clamp((1.164 * (YArr[i] - 16)) + (2.017 * (UArr[i] - 128))),
            255
        );
        i++;
    }
    let buffer = Uint8Array.from(RGBA).buffer;
    postMessage(buffer, [buffer]);
};