"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["3103"],{57503:function(s,e,n){s.exports=n.p+"static/image/yuv420p.2b2e7541.png"},90889:function(s,e,n){s.exports=n.p+"static/image/yuv420sp.07226b62.png"},11070:function(s,e,n){s.exports=n.p+"static/image/yuv_common_format.e0e86ac1.png"},58345:function(s,e,n){n.r(e);var r=n(85893),o=n(50065),i=n(11070),l=n(57503),t=n(90889);function a(s){let e=Object.assign({h1:"h1",a:"a",h2:"h2",p:"p",h3:"h3",img:"img",ul:"ul",li:"li",code:"code",pre:"pre",span:"span",h4:"h4"},(0,o.ah)(),s.components);return(0,r.jsxs)(r.Fragment,{children:[(0,r.jsxs)(e.h1,{id:"common-image-format",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#common-image-format",children:"#"}),"Common Image Format"]}),"\n",(0,r.jsxs)(e.h2,{id:"introduction",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#introduction",children:"#"}),"Introduction"]}),"\n",(0,r.jsx)(e.p,{children:"With the development of artificial intelligence, deep neural networks \u201Cblossom\u201D in the field of vision.\nIn order to fulfill the needs of different scenarios, we are exposed to a variety of image data formats.\nThis subsection provides a detailed introduction to several image data formats commonly used in deep learning scenarios: RGB, BGR, YUV, NV12 and Gray."}),"\n",(0,r.jsxs)(e.h2,{id:"rgb",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb",children:"#"}),"RGB"]}),"\n",(0,r.jsx)(e.p,{children:"RGB, a common color image format. Each pixel point of the image stores the luminance values (0 ~ 255, UINT8) for the red (Red), green (Green), and blue (Blue) color channels."}),"\n",(0,r.jsx)(e.p,{children:"Based on this, if recorded as (R, G, B), then (255,0,0), (0,255,0), (0,0,255) can represent the purest red, green, and blue, respectively.\nIf the values of the three RGB channels are all 0, the black color is obtained, if the values of the three channels are all maxed out at 255, the white color is obtained."}),"\n",(0,r.jsx)(e.p,{children:"RGB can represent up to 256x256x256\u224816.77 million colors, which is far more than the human eye can perceive (about 10 million), so RGB is used in a wide variety of display fields and is closely related to daily life."}),"\n",(0,r.jsx)(e.p,{children:"However, RGB has a feature that each pixel must store the R, G, and B channel values at the same time, i.e., each pixel needs 3 bytes of storage space, which is very unfriendly to the storage and transmission of video scenes, and will take up a lot of space and bandwidth."}),"\n",(0,r.jsxs)(e.h2,{id:"bgr",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#bgr",children:"#"}),"BGR"]}),"\n",(0,r.jsx)(e.p,{children:"The BGR image format is similar to RGB, except that the red, green and blue channels are arranged in a different order.\nIn the RGB format, the channel order of pixel points is red, green, and blue, while in the BGR format, the channel order of pixel points is blue, green, and red."}),"\n",(0,r.jsx)(e.p,{children:"The BGR format is commonly used in computer vision libraries such as OpenCV and is the default image format for some software and hardware, with which it has better compatibility."}),"\n",(0,r.jsx)(e.p,{children:"BGR, like RGB, has a large amount of data and is not suitable for the storage and transmission of video scenes.\nTherefore, we also need other image formats to replace RGB/BGR for video."}),"\n",(0,r.jsxs)(e.h2,{id:"yuv",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#yuv",children:"#"}),"YUV"]}),"\n",(0,r.jsxs)(e.h3,{id:"introduction-1",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#introduction-1",children:"#"}),"Introduction"]}),"\n",(0,r.jsx)(e.p,{children:"YUV, a color image format, where Y denotes Luminance, which is used to specify the brightness of a pixel (which can be interpreted as the degree of black and white),\nand U and V denote Chrominance or Chroma, which are used to specify the color of a pixel, and each of these values is expressed using UINT8."}),"\n",(0,r.jsx)(e.p,{children:"The YUV format uses luminance-chrominance separation, which means that only U and V are involved in the color representation, which is different from RGB."}),"\n",(0,r.jsx)(e.p,{children:"Even without the U and V components, we can \u201Crecognize\u201D the basic content of an image based on the Y component alone, except that it is presented as a black and white image.\nAnd the U and V components give color to these basics, and the black and white image evolves into a color image.\nThis means that we can minimize the sampling of the U and V components while retaining the Y-component information in order to minimize the amount of data, which is of great benefit to the storage and transmission of video data, which is why YUV is more suitable for the video processing field compared to RGB."}),"\n",(0,r.jsxs)(e.h3,{id:"yuv-common-format",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#yuv-common-format",children:"#"}),"YUV Common Format"]}),"\n",(0,r.jsx)(e.p,{children:"According to research, the human eye is more sensitive to luminance information than color information.\nYUV downsampling is based on the characteristics of the human eye, the human eye is relatively insensitive to the color information for compressed sampling, to get a relatively small file for playback and transmission.\nAccording to the percentage of Y and UV, the three commonly used YUV formats are: YUV444, YUV422, and YUV420."}),"\n",(0,r.jsx)(e.p,{children:"Three graphs are used to visualize the percentage of Y and UV for different acquisition methods."}),"\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.img,{alt:"yuv_common_format",src:i})}),"\n",(0,r.jsxs)(e.ul,{children:["\n",(0,r.jsx)(e.li,{children:"YUV444: Each Y component corresponds to a pair of UV components, occupying 3 bytes per pixel (Y + U + V = 8 + 8 + 8 = 24bits)."}),"\n",(0,r.jsx)(e.li,{children:"YUV422: Every two Y components share a pair of UV components, occupying 2 bytes per pixel (Y + 0.5U + 0.5V = 8 + 4 + 4 = 16bits)\u3002"}),"\n",(0,r.jsx)(e.li,{children:"YUV420: Every four Y components share a pair of UV components, occupying 1.5 bytes per pixel (Y + 0.25U + 0.25V = 8 + 2 + 2 = 12bits)."}),"\n"]}),"\n",(0,r.jsx)(e.p,{children:"At this point to understand the 4 in YUV4xx, this 4, in fact, expresses the maximum sharing unit! That is, up to 4 Y's share a pair of UV's."}),"\n",(0,r.jsxs)(e.h3,{id:"yuv420-in-detail",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#yuv420-in-detail",children:"#"}),"YUV420 in Detail"]}),"\n",(0,r.jsx)(e.p,{children:"In YUV420, a pixel point corresponds to a Y and a small 4X4 square corresponds to a U and V. Each pixel occupies 1.5 bytes.\nYUV420 can also be categorized into two formats, YUV420P and YUV420SP, based on different UV component arrangements."}),"\n",(0,r.jsx)(e.p,{children:"YUV420P is arranged as shown below by storing the U first and then the V:"}),"\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.img,{alt:"YUV420P",src:l})}),"\n",(0,r.jsx)(e.p,{children:"YUV420SP is stored alternately with UV and UV, arranged as shown below:"}),"\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.img,{alt:"YUV420SP",src:t})}),"\n",(0,r.jsxs)(e.p,{children:["At this point, I believe you can understand why the length of YUV420 data in memory is ",(0,r.jsx)(e.code,{children:"width * height * 3 / 2"}),"."]}),"\n",(0,r.jsxs)(e.h2,{id:"nv12",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#nv12",children:"#"}),"NV12"]}),"\n",(0,r.jsx)(e.p,{children:"NV12 is a widely used image format, especially in the field of video codec and automatic driving.\nNV12 can maintain the image brightness information while the amount of data is half of the RGB/BGR and other formats, which can reduce the time of loading input data for the model,\nso the embedded side usually chooses the NV12 image as the image data input during deployment."}),"\n",(0,r.jsx)(e.p,{children:"NV12 image format belongs to the YUV420SP format in YUV color space, which adopts the YUV 4:2:0 sampling method,\nwhere every four Y components share a set of U and V components, with the Y stored consecutively and the U and V stored in a crossed manner."}),"\n",(0,r.jsx)(e.p,{children:"The following is an introduction to the Python sample code for converting an RGB image to NV12 form and a C++ reference implementation of data preparation for NV12 input.\nAdditionally, we provide examples using two common image processing libraries to convert images to NV12 format in Python."}),"\n",(0,r.jsxs)(e.h3,{id:"rgb-to-nv12python",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb-to-nv12python",children:"#"}),"RGB to NV12(Python)"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"rgb_to_nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"image_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"array):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    r "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    g "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    b "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.299"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.587"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.114"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" b)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    u "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.169"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.331"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" b "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:")["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    v "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.419"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.081"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" b "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:")["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"zeros"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(shape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(u.shape["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"], u.shape["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"] "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", u.shape["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" j "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", u.shape["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            uv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" u"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            uv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" j "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" v"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Return separately"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'__main__'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(pil_image_data)."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"rgb_to_nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_data)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.h3,{id:"data-preparation-for-nv12-inputc",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#data-preparation-for-nv12-inputc",children:"#"}),"Data Preparation for NV12 Input(C++)"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-cpp",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<fstream>"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<iostream>"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<vector>"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<cstring>"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/dnn/hb_dnn.h"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hb_ucp.h"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hb_ucp_sys.h"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"read_image_2_tensor_as_nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"string"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"image_file"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                                    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNTensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"input_tensor) {"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // the struct of input shape is NHWC"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"validShape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dimensionSize["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"validShape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dimensionSize["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Mat bgr_mat "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"imread"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(image_file"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"IMREAD_COLOR);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"bgr_mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"empty"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"()) {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cout "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"image file not exist!"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"endl;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // resize"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Mat mat;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"create"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(input_h"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_w"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"bgr_mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"type"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"());"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(bgr_mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"size"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"()"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // convert to YUV420"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (input_h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"%"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"||"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"%"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:") {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cout "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input img height and width must aligned by 2!"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"endl;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Mat yuv_mat;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cvtColor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" yuv_mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"COLOR_BGR2YUV_I420);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"yuv_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"yuv_mat"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ptr"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<uint8_t>"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"();"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"y_data_src "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" yuv_data;"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // copy y data"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"y_data_dst "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"reinterpret_cast<uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*>"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"virAddr);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_h; "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"h) {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"memcpy"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(y_data_dst"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y_data_src"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_w);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y_data_src "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_w;"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    // add padding"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y_data_dst "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"stride["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // copy uv data"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"validShape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dimensionSize["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"validShape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dimensionSize["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"uv_data_dst "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"reinterpret_cast<uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*>"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"virAddr);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"u_data_src "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" yuv_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_w;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"uint8_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"v_data_src "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" u_data_src "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_width;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_height; "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"h) {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"auto"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cur_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_data_dst;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_width; "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"w) {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"      "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cur_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"u_data_src"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"      "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cur_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"v_data_src"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // add padding"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  uv_data_dst "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"stride["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // make sure memory data is flushed to DDR before inference"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMemFlush"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_SYS_MEM_CACHE_CLEAN);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMemFlush"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_SYS_MEM_CACHE_CLEAN);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n",(0,r.jsxs)(e.h3,{id:"additional-introduction",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#additional-introduction",children:"#"}),"Additional Introduction"]}),"\n",(0,r.jsxs)(e.h4,{id:"convert-image-to-nv12-by-pil",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#convert-image-to-nv12-by-pil",children:"#"}),"Convert image to NV12 by PIL"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" sys"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" PIL "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Image"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"generate_nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"input_path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"output_path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'./'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    img "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"open"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(input_path)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    w"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" img"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"size"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Convert images to YUV format"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    yuv_img "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" img"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"convert"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'YCbCr'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" u_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" v_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" yuv_img"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"split"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Convert Y, U, and V channel data to byte streams"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y_data_bytes "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"tobytes"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    u_data_bytes "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" u_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((u_data.width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", u_data.height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"tobytes"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    v_data_bytes "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" v_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((v_data.width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", v_data.height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"tobytes"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Arrange the UV data in the form of UVUVUVUV... "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    uvuvuv_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"bytearray"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" u_byte"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" v_byte "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"zip"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(u_data_bytes, v_data_bytes):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        uvuvuv_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"extend"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"([u_byte, v_byte])"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# y data"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" output_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"_y.bin"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"with"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"open"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(y_path, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'wb'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" f"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        f"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"write"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(y_data_bytes)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# uv data"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    uv_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" output_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"_uv.bin"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"with"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"open"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(uv_path, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'wb'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" f"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        f"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"write"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(uvuvuv_data)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    nv12_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y_data_bytes "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uvuvuv_data"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Save as NV12 format file"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    nv12_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" output_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"_nv12.bin"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"with"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"open"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(nv12_path, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'wb'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" f"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        f"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"write"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(nv12_data)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Input for the hbir model"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"frombuffer"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(y_data_bytes, dtype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"np.uint8)."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"reshape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", h, w, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"frombuffer"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(uvuvuv_data, dtype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"np.uint8)."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"reshape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", h"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", w"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"__main__"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"len"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(sys.argv)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Usage: python resize_image.py <input_path> <output_path>"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        sys"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"exit"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    input_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" sys"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"argv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    output_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" sys"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"argv"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"generate_nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(input_path, output_path)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.h4,{id:"convert-image-to-nv12-by-opencv",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#convert-image-to-nv12-by-opencv",children:"#"}),"Convert image to NV12 by OpenCV"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"image2nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"): "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    height"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"shape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"shape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    yuv420p "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cvtColor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image, cv2.COLOR_BGR2YUV_I420)."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"reshape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", ))"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" yuv420p"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" width"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    uv_planar "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" yuv420p"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" width"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":]."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"reshape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv_planar"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"transpose"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"reshape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"//"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", ))"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    nv12 "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"zeros_like"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(yuv420p)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# y component"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" width"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y         "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# uv component, UVUV alternate store"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" width"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv  "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Return separately"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" uv        "})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"image "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"imread"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./image.jpg"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nv12 "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"image2nv12"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.h2,{id:"gray",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#gray",children:"#"}),"Gray"]}),"\n",(0,r.jsx)(e.p,{children:"Gray image format, also known as grayscale image format, is a single-channel image format.\nIn a Gray image, each pixel contains only one luminance value, and each value is represented using the UINT8 type, which is an integer between 0 and 255.\nThis brightness value indicates how bright or dark each pixel in the image, with larger values indicating brighter pixels and smaller values indicating darker pixels."}),"\n",(0,r.jsx)(e.p,{children:"Gray image format is also a common format for other color image formats (such as RGB, YUV, etc.) when converting to a single-channel image, which contains only the luminance information of the image, and the image data is relatively small.\nTherefore, for some scenes that are less sensitive to image color information, it still has important application value."}),"\n",(0,r.jsxs)(e.h2,{id:"convert-between-image-formats",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#convert-between-image-formats",children:"#"}),"Convert between image formats"]}),"\n",(0,r.jsx)(e.p,{children:"In terms of image acquisition and display, RGB is mainly used, but in terms of image storage, processing and transmission, YUV is selected. In a complete application scenario, different image formats may need to be used."}),"\n",(0,r.jsx)(e.p,{children:"How to realize the conversion between image formats? Can be simply understood that there is a \u201Cstandard\u201D, based on this standard, through certain mathematical operations can be completed between different image formats.\nThe following computer vision library opencv encapsulated function as an example, see how to realize the image format conversion:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"})]}),"\n"]})})}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Read images, opencv reads images in BGR format by default"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"bgr_img "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"imread"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'example.jpg'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"imwrite"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'bgr_image.jpg'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", bgr_img)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Convert BGR format to RGB format"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"rgb_img "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cvtColor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(bgr_img, cv2.COLOR_BGR2RGB)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"imwrite"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'rgb_image.jpg'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", rgb_img)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Convert BGR format to YUV444 format"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"yuv_img "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cvtColor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(bgr_img, cv2.COLOR_BGR2YUV)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"imwrite"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'yuv_image.jpg'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", yuv_img)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Convert BGR format to GRAY format"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"gray_img "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cvtColor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(bgr_img, cv2.COLOR_BGR2GRAY)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cv2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"imwrite"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'gray_image.jpg'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", gray_img)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.p,{children:["We provide in the OE package between the common image format conversion source code (eg: RGB2NV12, BGR2RGB, etc.),\nimage processing commonly used transformer description of the document please refer to the user manual ",(0,r.jsx)(e.a,{href:"/latest/en/guide/ptq/ptq_appendix/transformer.html",children:"Image Processing Transformer"})," ,\nThe corresponding source code is located under the ",(0,r.jsx)(e.code,{children:"samples/ai_toolchain/horizon_model_convert_sample/01_common/python/data"})," path of the OE development kit."]}),"\n",(0,r.jsx)(e.p,{children:"Different image formats have different performances and advantages and disadvantages, and in practice, you can personalize the selection of image formats according to your needs."}),"\n",(0,r.jsxs)(e.h2,{id:"reference-links",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#reference-links",children:"#"}),"Reference Links"]}),"\n",(0,r.jsxs)(e.ul,{children:["\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.a,{href:"https://blog.csdn.net/onion2007/article/details/46805335",target:"_blank",rel:"noopener noreferrer",children:"https://blog.csdn.net/onion2007/article/details/46805335"})}),"\n"]}),"\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.a,{href:"https://zhuanlan.zhihu.com/p/538058910",target:"_blank",rel:"noopener noreferrer",children:"https://zhuanlan.zhihu.com/p/538058910"})}),"\n"]}),"\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.a,{href:"https://zhuanlan.zhihu.com/p/248116694",target:"_blank",rel:"noopener noreferrer",children:"https://zhuanlan.zhihu.com/p/248116694"})}),"\n"]}),"\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.a,{href:"https://blog.csdn.net/zego_0616/article/details/126658494",target:"_blank",rel:"noopener noreferrer",children:"https://blog.csdn.net/zego_0616/article/details/126658494"})}),"\n"]}),"\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsx)(e.p,{children:(0,r.jsx)(e.a,{href:"https://blog.csdn.net/luoyingxing/article/details/108516163",target:"_blank",rel:"noopener noreferrer",children:"https://blog.csdn.net/luoyingxing/article/details/108516163"})}),"\n"]}),"\n"]})]})}function c(){let s=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:e}=Object.assign({},(0,o.ah)(),s.components);return e?(0,r.jsx)(e,Object.assign({},s,{children:(0,r.jsx)(a,s)})):a(s)}e.default=c,c.__RSPRESS_PAGE_META={},c.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fappendix%2Fcommunity_articles%2Fcommon_image_format.mdx"]={toc:[{id:"introduction",text:"Introduction",depth:2},{id:"rgb",text:"RGB",depth:2},{id:"bgr",text:"BGR",depth:2},{id:"yuv",text:"YUV",depth:2},{id:"introduction-1",text:"Introduction",depth:3},{id:"yuv-common-format",text:"YUV Common Format",depth:3},{id:"yuv420-in-detail",text:"YUV420 in Detail",depth:3},{id:"nv12",text:"NV12",depth:2},{id:"rgb-to-nv12python",text:"RGB to NV12(Python)",depth:3},{id:"data-preparation-for-nv12-inputc",text:"Data Preparation for NV12 Input(C++)",depth:3},{id:"additional-introduction",text:"Additional Introduction",depth:3},{id:"convert-image-to-nv12-by-pil",text:"Convert image to NV12 by PIL",depth:4},{id:"convert-image-to-nv12-by-opencv",text:"Convert image to NV12 by OpenCV",depth:4},{id:"gray",text:"Gray",depth:2},{id:"convert-between-image-formats",text:"Convert between image formats",depth:2},{id:"reference-links",text:"Reference Links",depth:2}],title:"Common Image Format",frontmatter:{}}}}]);