"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["3658"],{31514:function(e,n,s){s.r(n);var r=s(85893),i=s(50065);function l(e){let n=Object.assign({h1:"h1",a:"a",p:"p",code:"code",strong:"strong",pre:"pre",span:"span",h2:"h2",h3:"h3",div:"div",ul:"ul",li:"li"},(0,i.ah)(),e.components);return(0,r.jsxs)(r.Fragment,{children:[(0,r.jsxs)(n.h1,{id:"the-hrt_model_exec-tool-introduction",children:[(0,r.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#the-hrt_model_exec-tool-introduction",children:"#"}),"The hrt_model_exec Tool Introduction"]}),"\n",(0,r.jsxs)(n.p,{children:["The ",(0,r.jsx)(n.code,{children:"hrt_model_exec"})," is a model execution tool that can evaluate the inference performance of the model and get the model information directly on the development board."]}),"\n",(0,r.jsx)(n.p,{children:"On one hand, it allows you to get a realistic understanding of the model's real performance; On the other hand, it also helps you to learn the speed limit that the model can achieve, which is useful information in application tuning."}),"\n",(0,r.jsxs)(n.p,{children:["The ",(0,r.jsx)(n.code,{children:"hrt_model_exec"})," tool source code is located in the ",(0,r.jsx)(n.code,{children:"samples/ucp_tutorial/tools/hrt_model_exec"})," path of the ",(0,r.jsx)(n.strong,{children:"horizon_s100_open_explorer"})," publication. The structure is as follows:"]}),"\n",(0,r.jsx)(n.pre,{className:"code",children:(0,r.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 include               # Header file"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 src                   # Source code"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 build.sh              # Compile script"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 build_x86.sh          # Compile to produce x86 tools"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 build_aarch64.sh      # Compile to produce aarch64 tools for the Linux system"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 build_qnx.sh          # Compile to produce aarch64 tools for the QNX system"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 CMakeLists.txt        "})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 README.md"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 script                       "})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2514\u2500\u2500 run_hrt_model_exec.sh    # The original aarch64 tool running script, which will be downloaded to the output_shared_s100_aarch64/script directory after compilation."})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 script_x86                   "})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2514\u2500\u2500 run_hrt_model_exec.sh    # The original x86 tool running script, which will be downloaded to the output_shared_S100_x86/script_x86 directory after compilation."})}),"\n",(0,r.jsx)(n.span,{className:"line",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsxs)(n.h2,{id:"running-process",children:[(0,r.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#running-process",children:"#"}),"Running Process"]}),"\n",(0,r.jsxs)(n.h3,{id:"building-method",children:[(0,r.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#building-method",children:"#"}),"Building Method"]}),"\n",(0,r.jsxs)(n.p,{children:["There is a pre-configured compilation script ",(0,r.jsx)(n.code,{children:"build.sh"})," in the ",(0,r.jsx)(n.code,{children:"ucp_tutorial/tools/hrt_model_exec"})," directory. The options ",(0,r.jsx)(n.code,{children:"-a x86"}),", ",(0,r.jsx)(n.code,{children:"-a aarch64-qnx"})," and ",(0,r.jsx)(n.code,{children:"-a aarch64"})," support three compilation modes respectively. You can use this script and specify the compilation options for compilation.\r\nIn addition, the directory also contains three compilation scripts, ",(0,r.jsx)(n.code,{children:"build_aarch64.sh"}),", ",(0,r.jsx)(n.code,{children:"build_qnx.sh"})," and ",(0,r.jsx)(n.code,{children:"build_x86.sh"}),", which correspond to three compilation options respectively. Compiling with these scripts is equivalent to using the ",(0,r.jsx)(n.code,{children:"build.sh"})," script and specifying the compilation options."]}),"\n",(0,r.jsx)(n.pre,{className:"code",children:(0,r.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Build board-side hrt_model_exec tools for linux system"})}),"\n",(0,r.jsxs)(n.span,{className:"line line-number",children:[(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"bash"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"-ex"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"build_aarch64.sh"})]}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Build x86-side hrt_model_exec tools"})}),"\n",(0,r.jsxs)(n.span,{className:"line line-number",children:[(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"bash"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"-ex"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"build_x86.sh"})]}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Build board-side hrt_model_exec tools for qnx system"})}),"\n",(0,r.jsxs)(n.span,{className:"line line-number",children:[(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"bash"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"-ex"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"build_qnx.sh"})]}),"\n"]})})}),"\n",(0,r.jsxs)(n.h3,{id:"execute-the-method",children:[(0,r.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#execute-the-method",children:"#"}),"Execute the Method"]}),"\n",(0,r.jsxs)(n.p,{children:["Take Linux environment as an example, after building board-side hrt_model_exec tools, the ",(0,r.jsx)(n.code,{children:"output_shared_S100_aarch64"})," folder will be generated.\r\nYou can use this tool by copying the folder to the board environment and executing ",(0,r.jsx)(n.code,{children:"output_shared_S100_aarch64/script/run_hrt_model_exec.sh"}),"."]}),"\n",(0,r.jsxs)(n.p,{children:["After building x86-side hrt_model_exec tools, the ",(0,r.jsx)(n.code,{children:"output_shared_S100_x86"})," folder will be generated.\r\nYou can use this tool on the x86 environment and executing ",(0,r.jsx)(n.code,{children:"output_shared_S100_x86/script_x86/run_hrt_model_exec.sh"}),"."]}),"\n",(0,r.jsxs)(n.p,{children:["The ",(0,r.jsx)(n.code,{children:"run_hrt_model_exec.sh"})," script is divided into two parts: setting environment variables and getting model information and inferring the model."]}),"\n",(0,r.jsx)(n.pre,{className:"code",children:(0,r.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Set environment variables"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# arch represents the architecture type, aarch64 or x86"})}),"\n",(0,r.jsxs)(n.span,{className:"line line-number",children:[(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"arch"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"aarch64"})]}),"\n",(0,r.jsxs)(n.span,{className:"line line-number",children:[(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bin"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"../"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"$arch"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"/bin/hrt_model_exec"})]}),"\n",(0,r.jsxs)(n.span,{className:"line line-number",children:[(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"lib"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"../"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"$arch"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"/lib/"})]}),"\n",(0,r.jsxs)(n.span,{className:"line line-number",children:[(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"export"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" LD_LIBRARY_PATH"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"${lib}"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:":"}),(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"${LD_LIBRARY_PATH}"})]}),"\n",(0,r.jsx)(n.span,{className:"line line-number"}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Get model information"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"${bin} model_info --model_file=xxx.hbm"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number"}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Infer the model "})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"${bin} infer --model_file=xxx.hbm --input_file=xxx.bin"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number"}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Get model performance"})}),"\n",(0,r.jsx)(n.span,{className:"line line-number",children:(0,r.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"${bin} perf --model_file=xxx.hbm --frame_count=200"})}),"\n"]})})}),"\n",(0,r.jsxs)(n.div,{className:"rspress-directive info",children:[(0,r.jsx)(n.div,{className:"rspress-directive-title",children:"Note"}),(0,r.jsx)(n.div,{className:"rspress-directive-content",children:(0,r.jsxs)(n.p,{children:["Before running, you need to modify the corresponding parameters of ",(0,r.jsx)(n.code,{children:"run_hrt_model_exec.sh"})," to ensure that the model and input files are correct. You can also use other parameters flexibly to use more functions."]})})]}),"\n",(0,r.jsxs)(n.h2,{id:"usage-scenarios",children:[(0,r.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#usage-scenarios",children:"#"}),"Usage Scenarios"]}),"\n",(0,r.jsxs)(n.p,{children:["The ",(0,r.jsx)(n.code,{children:"hrt_model_exec"})," tool supports three usage scenarios: view the model information, model inference, model performance evaluation."]}),"\n",(0,r.jsxs)(n.ul,{children:["\n",(0,r.jsxs)(n.li,{children:["\n",(0,r.jsxs)(n.p,{children:[(0,r.jsx)(n.a,{href:"/latest/en/guide/ucp/runtime/tool_introduction/hrt_model_exec/model_info.html",children:"View the Model Information"}),": Get model information, such as model input and output information, etc."]}),"\n"]}),"\n",(0,r.jsxs)(n.li,{children:["\n",(0,r.jsxs)(n.p,{children:[(0,r.jsx)(n.a,{href:"/latest/en/guide/ucp/runtime/tool_introduction/hrt_model_exec/model_infer.html",children:"Model Inference"}),": Perform model inference and get model inference results."]}),"\n"]}),"\n",(0,r.jsxs)(n.li,{children:["\n",(0,r.jsxs)(n.p,{children:[(0,r.jsx)(n.a,{href:"/latest/en/guide/ucp/runtime/tool_introduction/hrt_model_exec/performance_evaluation.html",children:"Model Performance Evaluation"}),": Perform model performance analysis and obtain performance analysis results."]}),"\n"]}),"\n"]})]})}function o(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,i.ah)(),e.components);return n?(0,r.jsx)(n,Object.assign({},e,{children:(0,r.jsx)(l,e)})):l(e)}n.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fucp%2Fruntime%2Ftool_introduction%2Fhrt_model_exec.mdx"]={toc:[{id:"running-process",text:"Running Process",depth:2},{id:"building-method",text:"Building Method",depth:3},{id:"execute-the-method",text:"Execute the Method",depth:3},{id:"usage-scenarios",text:"Usage Scenarios",depth:2}],title:"The hrt_model_exec Tool Introduction",frontmatter:{}}}}]);