"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["3897"],{15131:function(n,e,s){n.exports=s.p+"static/image/absorb_bn.15bb0789.png"},40904:function(n,e,s){n.exports=s.p+"static/image/fuse_bn.0ad1b6c5.jpg"},66174:function(n,e,s){s.r(e);var l=s(85893),i=s(50065),o=s(40904),r=s(15131);function a(n){let e=Object.assign({h1:"h1",a:"a",p:"p",h2:"h2",code:"code",pre:"pre",span:"span"},(0,i.ah)(),n.components);return(0,l.jsxs)(l.Fragment,{children:[(0,l.jsxs)(e.h1,{id:"operator-fusion",children:[(0,l.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#operator-fusion",children:"#"}),"Operator Fusion"]}),"\n",(0,l.jsx)(e.p,{children:"The operator fusion supported by the training tool can be divided into two main categories: 1. absorb BN. 2. fuse Add, ReLU(6)."}),"\n",(0,l.jsxs)(e.h2,{id:"absorb-bn",children:[(0,l.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#absorb-bn",children:"#"}),"Absorb BN"]}),"\n",(0,l.jsxs)(e.p,{children:["The purpose of absorbing ",(0,l.jsx)(e.code,{children:"BN"})," is to reduce the computing workload of the model. Since ",(0,l.jsx)(e.code,{children:"BN"})," is a linear transformation process, the parameters of ",(0,l.jsx)(e.code,{children:"BN"})," can be absorbed into the parameters of ",(0,l.jsx)(e.code,{children:"Conv"})," when both ",(0,l.jsx)(e.code,{children:"BN"})," and ",(0,l.jsx)(e.code,{children:"Conv"})," occur together,\nthus eliminating the computation of ",(0,l.jsx)(e.code,{children:"BN"})," from the deployed model."]}),"\n",(0,l.jsx)(e.p,{children:"The computation of absorption proceeds as follows:"}),"\n",(0,l.jsx)("img",{src:o,alt:"fuse_bn",height:"600",width:"600"}),"\n",(0,l.jsxs)(e.p,{children:["By absorbing ",(0,l.jsx)(e.code,{children:"BN"}),", ",(0,l.jsx)(e.code,{children:"Conv2d + BN2d"})," can be simplified to ",(0,l.jsx)(e.code,{children:"Conv2d"}),":"]}),"\n",(0,l.jsx)("img",{src:r,alt:"absorb_bn",height:"400",width:"550"}),"\n",(0,l.jsxs)(e.h2,{id:"fuse-addrelu6",children:[(0,l.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#fuse-addrelu6",children:"#"}),"Fuse Add\u3001ReLU(6)"]}),"\n",(0,l.jsx)(e.p,{children:"Different from the CUDA Kernel Fusion that fuses the CUDA Kernel to increase the computation speed, the fusion supported by the training tool is more on the quantization level."}),"\n",(0,l.jsxs)(e.p,{children:["The BPU hardware provides optimization for common model basic structures, and when computing ",(0,l.jsx)(e.code,{children:"Conv -> Add -> ReLU"})," operator combinations, it allows the data transfer between operators to retain a high degree of accuracy,\nimproving the overall numerical accuracy of the model. Therefore, when quantizing the model, we can consider ",(0,l.jsx)(e.code,{children:"Conv -> Add -> ReLU"})," as a whole."]}),"\n",(0,l.jsxs)(e.p,{children:["Since the training tool quantizes the model in terms of ",(0,l.jsx)(e.code,{children:"torch.nn.Module"}),", in order to treat ",(0,l.jsx)(e.code,{children:"Conv -> Add -> ReLU"})," as a whole during quantization, they need to be merged into a single ",(0,l.jsx)(e.code,{children:"Module"}),"."]}),"\n",(0,l.jsx)(e.p,{children:"The operator fusion, in addition to allowing the intermediate results to retain the high precision state, also eliminates the need to convert the intermediate results to a low precision representation, and therefore the execution speed will be faster compared to no fusion."}),"\n",(0,l.jsx)(e.p,{children:"Since operator fusion improves both model accuracy and model speed, it should generally be done for all fusable parts."}),"\n",(0,l.jsxs)(e.h2,{id:"implementation-principle",children:[(0,l.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#implementation-principle",children:"#"}),"Implementation Principle"]}),"\n",(0,l.jsx)(e.p,{children:"Thanks to FX's advantage of obtaining computational graphs, the training tool can automate the analysis of the model's computational graphs, match the fusible parts according to the predefined fusion pattern, and implement the fusion operation by submodule substitution.\nAn example is given below:"}),"\n",(0,l.jsx)(e.p,{children:"The absorption of BN and the fusion of Add, ReLU(6) can be accomplished by the same mechanism, so no distinction is needed in fusion."}),"\n",(0,l.jsx)(e.pre,{className:"code",children:(0,l.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,l.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantization "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" DeQuantStub"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantization "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" QuantStub"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantization "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" fuse_fx"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"class"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"ModelForFusion"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"torch"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"Module"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    ):"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"super"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(ModelForFusion, self)."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantx "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"QuantStub"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quanty "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"QuantStub"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"conv "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"Conv2d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"bn "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"BatchNorm2d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"relu "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"ReLU"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dequant "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"DeQuantStub"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"forward"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"x"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"y"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"quantx"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        y "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"quanty"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(y)"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"conv"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"bn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" x "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" y"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"relu"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"dequant"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" x"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"float_model "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"ModelForFusion"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"fused_model "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"fuse_fx"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(float_model)"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(fused_model)"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:'"""'})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"ModelForFusion("})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  (quantx): QuantStub()"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  (quanty): QuantStub()"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  (conv): Identity()"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  (bn): Identity()"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  (relu): Identity()"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  (dequant): DeQuantStub()"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  (_generated_add_0): ConvAddReLU2d("})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    (conv): Conv2d(3, 3, kernel_size=(3, 3), stride=(1, 1))"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    (relu): ReLU()"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  )"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:")"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"def forward(self, x, y):"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    quantx = self.quantx(x);  x = None"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    quanty = self.quanty(y);  y = None"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    _generated_add_0 = self._generated_add_0"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    add_1 = self._generated_add_0(quantx, quanty);  quantx = quanty = None"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    dequant = self.dequant(add_1);  add_1 = None"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"    return dequant"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:'"""'})}),"\n"]})})}),"\n",(0,l.jsxs)(e.p,{children:["As you can see, after performing the operator fusion operation to the model, the BN is absorbed into the Conv, and the Conv, Add, and ReLU are fused into a Module (",(0,l.jsx)(e.code,{children:"_generated_add_0"}),").\nThe original submodule is replaced with ",(0,l.jsx)(e.code,{children:"Identity"})," and is not called in the ",(0,l.jsx)(e.code,{children:"forward"})," code."]}),"\n",(0,l.jsxs)(e.p,{children:["FX automatically replaces the plus sign of ",(0,l.jsx)(e.code,{children:"x = x + y"})," in the model with a ",(0,l.jsx)(e.code,{children:"Module"})," form named ",(0,l.jsx)(e.code,{children:"_generated_add_0"})," to support operations related to operator fusion and quantization."]}),"\n",(0,l.jsxs)(e.h2,{id:"operators-that-can-be-fused",children:[(0,l.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#operators-that-can-be-fused",children:"#"}),"Operators that can be Fused"]}),"\n",(0,l.jsx)(e.p,{children:"The currently supported combinations of fusable operators are shown in the following function definitions:"}),"\n",(0,l.jsx)(e.pre,{className:"code",children:(0,l.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,l.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" operator"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_nn"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_patterns"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"():"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    convs "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Conv2d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ConvTranspose2d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Conv3d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Linear"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    )"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    bns "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"BatchNorm1d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"BatchNorm2d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"BatchNorm3d"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"SyncBatchNorm)"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    adds "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantized"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"FloatFunctional"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"add"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        horizon_nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantized"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"FloatFunctional"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"add"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        torch"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"add"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        operator"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"add"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# the plus sign used in the code"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    )"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    relus "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ReLU"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ReLU6"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"functional"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"relu"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"functional"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"relu6)"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" conv "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" convs"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" bn "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" bns"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" add "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" adds"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" relu "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" relus"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# conv bn"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((bn, conv))(ConvBNAddReLUFusion)"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# conv relu"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((relu, conv))(ConvBNAddReLUFusion)"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# conv add"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((add, conv, MatchAllNode))("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        ConvBNAddReLUFusion"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# the output of conv is used as the first input to add"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((add, MatchAllNode, conv))("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        ConvBNAddedReLUFusion"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# The output of conv is used as the second input to add"})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# conv bn relu"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((relu, (bn, conv)))("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        ConvBNAddReLUFusion"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# conv bn add"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((add, (bn, conv), MatchAllNode))("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        ConvBNAddReLUFusion"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((add, MatchAllNode, (bn, conv)))("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        ConvBNAddedReLUFusion"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# conv add relu"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((relu, (add, conv, MatchAllNode)))("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        ConvBNAddReLUFusion"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((relu, (add, MatchAllNode, conv)))("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        ConvBNAddedReLUFusion"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number"}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# conv bn add relu"})]}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        (relu, (add, (bn, conv), MatchAllNode))"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )(ConvBNAddReLUFusion)"})}),"\n",(0,l.jsxs)(e.span,{className:"line line-number",children:[(0,l.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                    "}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_fusion_pattern"}),(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                        (relu, (add, MatchAllNode, (bn, conv)))"})}),"\n",(0,l.jsx)(e.span,{className:"line line-number",children:(0,l.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    )(ConvBNAddedReLUFusion)"})}),"\n"]})})})]})}function t(){let n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:e}=Object.assign({},(0,i.ah)(),n.components);return e?(0,l.jsx)(e,Object.assign({},n,{children:(0,l.jsx)(a,n)})):a(n)}e.default=t,t.__RSPRESS_PAGE_META={},t.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fplugin%2Fadvanced_tutorial%2Fop_fusion.mdx"]={toc:[{id:"absorb-bn",text:"Absorb BN",depth:2},{id:"fuse-addrelu6",text:"Fuse Add\u3001ReLU(6)",depth:2},{id:"implementation-principle",text:"Implementation Principle",depth:2},{id:"operators-that-can-be-fused",text:"Operators that can be Fused",depth:2}],title:"Operator Fusion",frontmatter:{}}}}]);