"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["5258"],{35149:function(e,n,r){r.r(n);var i=r(85893),t=r(50065);function s(e){let n=Object.assign({h1:"h1",a:"a",h2:"h2",p:"p",ul:"ul",li:"li",code:"code",h3:"h3",h4:"h4",pre:"pre",span:"span",div:"div",ol:"ol",table:"table",thead:"thead",tr:"tr",th:"th",tbody:"tbody",td:"td"},(0,t.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(n.h1,{id:"environment-deployment",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#environment-deployment",children:"#"}),"Environment Deployment"]}),"\n",(0,i.jsxs)(n.h2,{id:"foreword",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#foreword",children:"#"}),"Foreword"]}),"\n",(0,i.jsx)(n.p,{children:"Horizon OpenExplorer currently provides 2 sets of model quantization schemes at the same time."}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"PTQ: Post-training Quantization."}),"\n",(0,i.jsx)(n.li,{children:"QAT: Quantization Awareness Training, which only supports the Pytorch framework for now."}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"Among them:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["Both solutions do not interfere with the training phase of the floating-point model, which is your own responsibility.\r\nHorizon has also provided some open-source implementations of the public version of Pytorch for efficient models in classification, detection, segmentation,\r\nand other scenarios in the ",(0,i.jsx)(n.code,{children:"samples/ai_toolchain/horizon_model_train_sample"})," for reference, with the support for training and replication on the host."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["For PTQ scheme, you need to quantize the model in the host development environment, and then copy the compiled ",(0,i.jsx)(n.code,{children:".hbm"})," model to the dev board environment for subsequent deployment."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["For the QAT scheme, you need to complete the QAT training of the model in the host development environment, perform the quantization conversion, and then copy the compiled ",(0,i.jsx)(n.code,{children:".hbm"})," model to the dev board environment for subsequent deployment."]}),"\n"]}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"For both of the above quantization schemes and the development environment of the efficient model, Horizon provides both local manual installation and Docker containers.\r\nWe strongly recommend using Docker containers as they do not pollute the local environment and is easy to use, descriptions of these two are included in the following sections."}),"\n",(0,i.jsxs)(n.h2,{id:"development-environment-deployment",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#development-environment-deployment",children:"#"}),"Development Environment Deployment"]}),"\n",(0,i.jsxs)(n.h3,{id:"development-machine-preparation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#development-machine-preparation",children:"#"}),"Development Machine Preparation"]}),"\n",(0,i.jsx)(n.p,{children:"In order to use the toolchain smoothly, we recommends that the development machine you choose should meet the following requirements:"}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"30%"}}),(0,i.jsx)("col",{style:{width:"70%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"HW/OS"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"REQUIREMENTS"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"CPU"}),(0,i.jsx)("td",{children:"CPU above I3 or same level processor as E3/E5"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"Memory Size"}),(0,i.jsx)("td",{children:"16G or above"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"GPU"}),(0,i.jsxs)("td",{children:["CUDA12.6, Drive Version: Linux: >= 550.163.01",(0,i.jsx)("br",{}),"\r\nAdapted graphics cards include but are not limited to: ",(0,i.jsx)("br",{}),"\r\n1)GeForce RTX 3090 ",(0,i.jsx)("br",{}),"\r\n2)GeForce RTX 2080 Ti ",(0,i.jsx)("br",{}),"\r\n3)NVIDIA TITAN V ",(0,i.jsx)("br",{}),"\r\n4)Tesla V100S-PCIE-32GB ",(0,i.jsx)("br",{}),"\r\n5)A100"]})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"OS"}),(0,i.jsx)("td",{children:"Native Ubuntu 22.04"})]})]})]}),"\n",(0,i.jsxs)(n.p,{children:["For more information about CUDA compatibility with graphics cards, refer to ",(0,i.jsx)(n.a,{href:"https://docs.nvidia.com/deploy/cuda-compatibility/",target:"_blank",rel:"noopener noreferrer",children:"NVIDIA website information"}),"."]}),"\n",(0,i.jsxs)(n.h3,{id:"model_docker_env",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model_docker_env",children:"#"}),"Docker Container Deployment"]}),"\n",(0,i.jsxs)(n.h4,{id:"docker-base-environment",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#docker-base-environment",children:"#"}),"Docker Base Environment"]}),"\n",(0,i.jsx)(n.p,{children:"Horizon requires the following Docker base environment, please complete the installation on your host computer in advance."}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["Docker (20.10.10 and above, 20.10.10 is recommended), refer to the ",(0,i.jsx)(n.a,{href:"https://docs.docker.com/install/",target:"_blank",rel:"noopener noreferrer",children:"Docker Installation Manual"}),"."]}),"\n",(0,i.jsxs)(n.li,{children:["NVIDIA Container Toolkit (1.16.2 and above, 1.17.8 is recommended), refer to installation manual ",(0,i.jsx)(n.a,{href:"https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/latest/install-guide.html",target:"_blank",rel:"noopener noreferrer",children:"NVIDIA Container Toolkit installation manual"}),"."]}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"After completing the installation of the Docker environment, remember to add non-root users into Docker users group by running below command:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sudo"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"groupadd"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"docker"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sudo"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"gpasswd"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"-a"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${USER} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"docker"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sudo"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"service"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"docker"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"restart"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.h4,{id:"docker_image_usage",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#docker_image_usage",children:"#"}),"Docker Image Usage"]}),"\n",(0,i.jsx)(n.p,{children:"To help you quickly use the toolchain, we provide a Docker image containing the complete development environment, which greatly simplifies the deployment process of the development environment."}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive tip",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Hint"}),(0,i.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,i.jsx)(n.p,{children:"If you have downloaded the offline image, you need to use the following command to load the image locally first."}),(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"docker"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"load"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"-i"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"ai_toolchain_ubuntu_22_s100_xxx.tar"})]}),"\n"]})})})]})]}),"\n",(0,i.jsx)(n.p,{children:"You can start the Docker container corresponding to the current OE version by running the following script directly from the first level of the OE package:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"bash"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"run_docker.sh"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"data/"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["Where ",(0,i.jsx)(n.code,{children:"data"})," is the path to the evaluation dataset folder. Please create the path before running the command, otherwise loading problems may occur."]}),"\n",(0,i.jsxs)(n.p,{children:["If you want to use the CPU version of the Docker image, you need to add the ",(0,i.jsx)(n.code,{children:"cpu"})," parameter:"]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"bash"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"run_docker.sh"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"data/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"cpu"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["Since the environment variables ",(0,i.jsx)(n.code,{children:"PATH"})," and ",(0,i.jsx)(n.code,{children:"LD_LIBRARY_PATH"})," are configured during the build process of the OE Docker image,\r\nnot using the recommended way (e.g., docker attach) to enter the container may result in the environment variables not being loaded correctly,\r\nwhich may lead to the use of abnormalities in tools such as Cmake, GCC, CUDA, and so on."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["If you want the Docker container to exit without removing it, use the command line ",(0,i.jsx)(n.code,{children:"docker run -it"})," to start it manually, without the ",(0,i.jsx)(n.code,{children:"--rm"})," option."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["If you want the Docker container to run background after startup, add the ",(0,i.jsx)(n.code,{children:"-d"})," option after the command line ",(0,i.jsx)(n.code,{children:"docker run -it"}),", the container ID will be returned after the container is started,\r\nand then you can enter the container again with the command ",(0,i.jsx)(n.code,{children:"docker exec -it {container ID} /bin/bash"}),"."]}),"\n"]}),"\n"]})})]}),"\n",(0,i.jsxs)(n.h3,{id:"local-manual-installation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#local-manual-installation",children:"#"}),"Local Manual Installation"]}),"\n",(0,i.jsx)(n.p,{children:"For manual local environment setup, you can enter the package/host folder and install the required files."}),"\n",(0,i.jsxs)(n.h4,{id:"ptq-quantization-environment-dependence",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#ptq-quantization-environment-dependence",children:"#"}),"PTQ Quantization Environment Dependence"]}),"\n",(0,i.jsx)(n.p,{children:"The PTQ scheme has the following software dependencies on the base software of the development machine operating environment:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Operating system: Ubuntu22.04"}),"\n",(0,i.jsx)(n.li,{children:"Python3.10"}),"\n",(0,i.jsx)(n.li,{children:"libpython3.10"}),"\n",(0,i.jsx)(n.li,{children:"python3-devel"}),"\n",(0,i.jsx)(n.li,{children:"python3-pip"}),"\n",(0,i.jsx)(n.li,{children:"gcc&g++: 12.2.1"}),"\n",(0,i.jsx)(n.li,{children:"graphviz"}),"\n"]}),"\n",(0,i.jsxs)(n.h4,{id:"qat_env_deploy",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#qat_env_deploy",children:"#"}),"QAT Quantization Environment Dependence"]}),"\n",(0,i.jsx)(n.p,{children:"The QAT quantization environment is installed in the local environment and you need to ensure that the following basic environmental conditions are met."}),"\n",(0,i.jsx)(n.p,{children:"The environmental dependencies required for the quantitative training tool to be trained are listed below:"}),"\n",(0,i.jsxs)(n.table,{children:[(0,i.jsx)(n.thead,{children:(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.th,{align:"center",children:"HW/OS"}),(0,i.jsx)(n.th,{align:"center",children:"GPU"}),(0,i.jsx)(n.th,{align:"center",children:"CPU"})]})}),(0,i.jsxs)(n.tbody,{children:[(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"os"}),(0,i.jsx)(n.td,{align:"center",children:"Ubuntu22.04"}),(0,i.jsx)(n.td,{align:"center",children:"Ubuntu22.04"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"cuda"}),(0,i.jsx)(n.td,{align:"center",children:"12.6"}),(0,i.jsx)(n.td,{align:"center",children:"N/A"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"python"}),(0,i.jsx)(n.td,{align:"center",children:"3.10"}),(0,i.jsx)(n.td,{align:"center",children:"3.10"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"torch"}),(0,i.jsx)(n.td,{align:"center",children:"2.6.0+cu126"}),(0,i.jsx)(n.td,{align:"center",children:"2.6.0+cpu"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"torchvision"}),(0,i.jsx)(n.td,{align:"center",children:"0.21.0+cu126"}),(0,i.jsx)(n.td,{align:"center",children:"0.21.0+cpu"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"Recommended Graphics Cards"}),(0,i.jsx)(n.td,{align:"center",children:"titan v/2080ti/v100/3090"}),(0,i.jsx)(n.td,{align:"center",children:"N/A"})]})]})]}),"\n",(0,i.jsx)(n.p,{children:"After completing the training of the QAT model, you can install the relevant toolkits in the current training environment and complete the subsequent model conversion directly through the interface call."}),"\n",(0,i.jsxs)(n.h2,{id:"runtime-environment-deployment",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#runtime-environment-deployment",children:"#"}),"Runtime Environment Deployment"]}),"\n",(0,i.jsx)(n.p,{children:"Once the model has been quantized, the compiled model can be deployed on the dev board environment for inference and execution."}),"\n",(0,i.jsx)(n.p,{children:"To deploy the runtime environment, you need to prepare a dev board with the system image programmed, and then copy the relevant supplementary files to the dev board."}),"\n",(0,i.jsxs)(n.h3,{id:"dev-board-preparation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#dev-board-preparation",children:"#"}),"Dev Board Preparation"]}),"\n",(0,i.jsx)(n.p,{children:"At this stage, you need to verify the usability of the dev board and program the available system images to the board."}),"\n",(0,i.jsxs)(n.h3,{id:"board-side-tool-installation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#board-side-tool-installation",children:"#"}),"Board Side Tool Installation"]}),"\n",(0,i.jsx)(n.p,{children:"Some of the supplementary tools of the toolchain are not included in the system image, but can be copied to the dev board by running the installation script in the OE package in the host environment, as follows:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"package/board/hrt_model_exec"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"bash"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"build_aarch64.sh"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive info",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,i.jsxs)(n.p,{children:["Where ",(0,i.jsx)(n.code,{children:"${board_ip}"})," is the IP address you set for the dev board. Make sure that you can successfully access this IP on the development PC."]}),(0,i.jsxs)(n.p,{children:["After the supplementary files are successfully installed, please restart the dev board and execute ",(0,i.jsx)(n.code,{children:"hrt_model_exec --help"})," on the dev board to verify if the installation is successful."]})]})]})]})}function o(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,t.ah)(),e.components);return n?(0,i.jsx)(n,Object.assign({},e,{children:(0,i.jsx)(s,e)})):s(e)}n.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fenv_install.mdx"]={toc:[{id:"foreword",text:"Foreword",depth:2},{id:"development-environment-deployment",text:"Development Environment Deployment",depth:2},{id:"development-machine-preparation",text:"Development Machine Preparation",depth:3},{id:"model_docker_env",text:"Docker Container Deployment",depth:3},{id:"docker-base-environment",text:"Docker Base Environment",depth:4},{id:"docker_image_usage",text:"Docker Image Usage",depth:4},{id:"local-manual-installation",text:"Local Manual Installation",depth:3},{id:"ptq-quantization-environment-dependence",text:"PTQ Quantization Environment Dependence",depth:4},{id:"qat_env_deploy",text:"QAT Quantization Environment Dependence",depth:4},{id:"runtime-environment-deployment",text:"Runtime Environment Deployment",depth:2},{id:"dev-board-preparation",text:"Dev Board Preparation",depth:3},{id:"board-side-tool-installation",text:"Board Side Tool Installation",depth:3}],title:"Environment Deployment",frontmatter:{}}}}]);