"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["5651"],{58771:function(e,n,s){s.r(n);var i=s(85893),r=s(50065);function l(e){let n=Object.assign({h1:"h1",a:"a",h2:"h2",p:"p",ol:"ol",li:"li",div:"div",strong:"strong",pre:"pre",code:"code",span:"span",table:"table",thead:"thead",tr:"tr",th:"th",tbody:"tbody",td:"td"},(0,r.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(n.h1,{id:"prepare-in-detail",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#prepare-in-detail",children:"#"}),"Prepare in Detail"]}),"\n",(0,i.jsxs)(n.h2,{id:"definition-of-prepare",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#definition-of-prepare",children:"#"}),"Definition of Prepare"]}),"\n",(0,i.jsx)(n.p,{children:"Prepare is the process of converting a floating-point model into a pseudo-quantized model. This process involves several key steps:"}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Operator Replacement: Some torch function operators (such as F.interpolate) need to have FakeQuantize nodes inserted during quantization. Therefore, these operators are replaced with corresponding Module type implementations (horizon_plugin_pytorch.nn.Interpolate) to place the FakeQuantize nodes inside this Module. The model before and after replacement is equivalent."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Operator Fusion: BPU supports fusing specific computational patterns, where the intermediate results of fused operators are represented with high precision. Therefore, we replace multiple operators to be fused with a single Module to prevent quantizing the intermediate results. The model before and after fusion is also equivalent."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Operator Conversion: Floating-point operators are replaced with QAT (Quantized Awareness Training) operators. According to the configured qconfig, QAT operators will add FakeQuantize nodes at the input/output/weights."}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsx)(n.p,{children:"\nTo keep converted QAT operators work as expected, please ensure that no further modifications are made to the model after calling prepare. For example, converting an unfused BN to a sync BN after prepare may cause the QAT BN to be modified again. The conversion to sync BN should be done before calling prepare."})})]}),"\n",(0,i.jsxs)(n.ol,{start:"4",children:["\n",(0,i.jsx)(n.li,{children:"Model Structure Check: The QAT model is checked, and a check result file is generated."}),"\n"]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive info",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Accuracy Description"})}),(0,i.jsx)(n.p,{children:"The model after prepare differs from the floating-point model in terms of computational logic in the following aspects:"}),(0,i.jsx)(n.p,{children:"Pseudo-quantization nodes are added to the model.\nFor a very small number of operators (such as reciprocal) whose outputs may have extremely large values, to adapt to quantization, their outputs will be clipped to a reasonable range by default."}),(0,i.jsx)(n.p,{children:"The above operations will cause changes in the numerical values of the model."})]})]}),"\n",(0,i.jsx)(n.p,{children:"The usage of the prepare interface is as follows:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-py",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quantization"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"prepare "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" prepare"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" PrepareMethod"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quantization"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qconfig_template "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    default_qat_qconfig_setter"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    sensitive_op_qat_8bit_weight_16bit_fixed_act_qconfig_setter"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:")"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# When using templates, example_inputs and qconfig_setter must be provided."})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# When method is PrepareMethod.JIT_STRIP or PrepareMethod.JIT, example_inputs must be provided."})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# def prepare("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     model: torch.nn.Module,"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     example_inputs: Any = None,   # used to get model's graph structure, ensuring it can be used to run forward."})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     qconfig_setter: Optional[Union[Tuple[QconfigSetterBase, ...], QconfigSetterBase]] = None,  # qconfig template, supports multiple templates, priority from high to low."})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     method: PrepareMethod = PrepareMethod.JIT_STRIP,  # prepare method"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# ) -> torch.nn.Module:"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    float_model,"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"example_inputs,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sensitive_op_qat_8bit_weight_16bit_fixed_act_qconfig_setter"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(table, ratio"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        default_qat_qconfig_setter,"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    method"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"PrepareMethod.JIT,"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.h2,{id:"preparemethod",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#preparemethod",children:"#"}),"PrepareMethod"]}),"\n",(0,i.jsx)(n.p,{children:"The prepare method includes JIT_STRIP and EAGER. JIT_STRIP belongs to Graph Mode, while EAGER belongs to PrepareMethod.EAGER. Their comparison is as follows:"}),"\n",(0,i.jsxs)(n.table,{children:[(0,i.jsx)(n.thead,{children:(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.th,{children:"method"}),(0,i.jsx)(n.th,{children:"Principle"}),(0,i.jsx)(n.th,{children:"Advantages"}),(0,i.jsx)(n.th,{children:"Disadvantages"})]})}),(0,i.jsxs)(n.tbody,{children:[(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{children:"PrepareMethod.JIT_STRIP(Graph Mode)"}),(0,i.jsx)(n.td,{children:"Use hooks and subclass tensor to get the graph structure, performing operator replacement/operator fusion on the original forward."}),(0,i.jsx)(n.td,{children:"Fully automatic, minimal code modification, hides many detail issues, easy to debug."}),(0,i.jsx)(n.td,{children:"Dynamic code blocks need special handling."})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{children:"PrepareMethod.EAGER(Eager Mode)"}),(0,i.jsx)(n.td,{children:"Does not sense the graph structure. operator replacement/operator fusion needs to be done manually."}),(0,i.jsx)(n.td,{children:"Flexible usage, controllable process, easy to debug and handle various special needs."}),(0,i.jsx)(n.td,{children:"Requires more manual operations, more code modifications, high learning cost."})]})]})]}),"\n",(0,i.jsx)(n.p,{children:"Currently, JIT_STRIP is our recommended method. The JIT_STRIP will identify and skip pre-process and post-process based on the positions of QuantStub and DequantStub in the model."}),"\n",(0,i.jsxs)(n.h2,{id:"example",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#example",children:"#"}),"Example"]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-py",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" copy"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" nn"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"nn "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" functional "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" F"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quantization "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" DeQuantStub"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" QuantStub"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" March"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" set_march"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"fx"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"jit_scheme "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" Tracer"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quantization "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    FakeQuantState"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    get_qconfig"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    PrepareMethod"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    prepare"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    set_fake_quantize"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:")"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"class"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"Net"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"nn"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"Module"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"input_size"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"class_num"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:") "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"->"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"super"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quant0 "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"QuantStub"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quant1 "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"QuantStub"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"dequant "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"DeQuantStub"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"conv "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"Conv2d"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bn "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"BatchNorm2d"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"classifier "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"Conv2d"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", class_num, input_size)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"loss "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"CrossEntropyLoss"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"forward"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"other"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"target"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Preprocess that does not need quantization. Use JIT_STRIP to exclude these operations from the computational graph."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:") "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"quant0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        y "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"quant1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(other)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        n "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"random"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"randint"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        m "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"random"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"randint"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Since the python code is not regenerated, this dynamic loop is retained in the QAT model."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" _ "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(n):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" _ "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(m):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Dynamic code blocks involving operator replacement or fusion must be marked."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The marked part refers to the logic that requires operator replacement or fusion, rather than the for loop."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"with"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" Tracer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"dynamic_block"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(self, "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ConvBnAdd"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                    x "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"conv"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                    x "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"bn"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                    x "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" x "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" y"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        x "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"classifier"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"squeeze"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Since the python code is not regenerated, this dynamic control flow is retained in the QAT model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"training"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"assert"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" target "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"is"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"not"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            x "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"dequant"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" F"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"cross_entropy"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(torch."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"softmax"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x, dim"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), target)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"else"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"argmax"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(x, dim"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"Net"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"6"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"train_example_input "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"rand"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"6"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"6"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"rand"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"6"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"6"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"tensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"([["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"], ["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]]),"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:")"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"eval_example_input "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" train_example_input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"eval"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"set_march"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"nash-e"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qconfig "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"get_qconfig"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"copy."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"deepcopy"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(eval_example_input),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    method"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"PrepareMethod.JIT_STRIP,"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"graph"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print_tabular"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# opcode         name              target                                                     args                              kwargs"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# -------------  ----------------  ---------------------------------------------------------  --------------------------------  ----------"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# placeholder    input_0           input_0                                                    ()                                {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_module    quant0            quant0                                                     (input_0,)                        {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# placeholder    input_1           input_1                                                    ()                                {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_module    quant1            quant1                                                     (input_1,)                        {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_module    conv              conv                                                       (quant0,)                         {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_module    bn                bn                                                         (conv,)                           {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# get_attr       _generated_add_0  _generated_add_0                                           ()                                {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_method    add_2             add                                                        (_generated_add_0, bn, quant1)    {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# scope_end is automatically inserted during the trace process to mark the boundaries of sub-modules or dynamic code blocks, not corresponding to any calculations"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_function  scope_end         <function Tracer.scope_end at 0x7f65d90e5e50>              ('_dynamic_block_ConvBnAdd',)     {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_module    conv_1            conv                                                       (add_2,)                          {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_module    bn_1              bn                                                         (conv_1,)                         {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# get_attr       _generated_add_1  _generated_add_0                                           ()                                {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_method    add_3             add                                                        (_generated_add_1, bn_1, quant1)  {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_function  scope_end_1       <function Tracer.scope_end at 0x7f65d90e5e50>              ('_dynamic_block_ConvBnAdd',)     {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_module    classifier        classifier                                                 (add_3,)                          {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_function  squeeze           <method 'squeeze' of 'torch._C._TensorBase' objects>       (classifier,)                     {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_function  argmax            <built-in method argmax of type object at 0x7f66f04cf820>  (squeeze,)                        {'dim': 1}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# call_function  scope_end_2       <function Tracer.scope_end at 0x7f65d90e5e50>              ('',)                             {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# output         output            output                                                     ((argmax,),)                      {}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(qat_model)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# GraphModuleImpl("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (quant0): QuantStub("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     (activation_post_process): FakeQuantize("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       fake_quant_enabled=tensor([1], dtype=torch.uint8), observer_enabled=tensor([1], dtype=torch.uint8),            quant_min=-128, quant_max=127, dtype=qint8, qscheme=torch.per_tensor_symmetric, ch_axis=-1,         scale=tensor([1.]), zero_point=tensor([0])"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       (activation_post_process): MinMaxObserver(min_val=tensor([]), max_val=tensor([]))"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (quant1): QuantStub("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     (activation_post_process): FakeQuantize("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       fake_quant_enabled=tensor([1], dtype=torch.uint8), observer_enabled=tensor([1], dtype=torch.uint8),            quant_min=-128, quant_max=127, dtype=qint8, qscheme=torch.per_tensor_symmetric, ch_axis=-1,         scale=tensor([1.]), zero_point=tensor([0])"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       (activation_post_process): MinMaxObserver(min_val=tensor([]), max_val=tensor([]))"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (dequant): DeQuantStub()"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (conv): Identity()  # Since the forward code remains unchanged, conv and bn will still be executed, so after fusion, Conv and Bn must be replaced with Identity"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (bn): Identity()"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (classifier): Conv2d("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     3, 2, kernel_size=(6, 6), stride=(1, 1)"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     (activation_post_process): FakeQuantize("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       fake_quant_enabled=tensor([1], dtype=torch.uint8), observer_enabled=tensor([1], dtype=torch.uint8),            quant_min=-128, quant_max=127, dtype=qint8, qscheme=torch.per_tensor_symmetric, ch_axis=-1,         scale=tensor([1.]), zero_point=tensor([0])"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       (activation_post_process): MinMaxObserver(min_val=tensor([]), max_val=tensor([]))"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     (weight_fake_quant): FakeQuantize("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       fake_quant_enabled=tensor([1], dtype=torch.uint8), observer_enabled=tensor([1], dtype=torch.uint8),            quant_min=-128, quant_max=127, dtype=qint8, qscheme=torch.per_channel_symmetric, ch_axis=0,         scale=tensor([1., 1.]), zero_point=tensor([0, 0])"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       (activation_post_process): MinMaxObserver(min_val=tensor([]), max_val=tensor([]))"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (loss): CrossEntropyLoss()"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   (_generated_add_0): ConvAdd2d(  # Automatically replace '+' with Module form, and fuse Conv and Bn into it"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     3, 3, kernel_size=(1, 1), stride=(1, 1)"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     (activation_post_process): FakeQuantize("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       fake_quant_enabled=tensor([1], dtype=torch.uint8), observer_enabled=tensor([1], dtype=torch.uint8),            quant_min=-128, quant_max=127, dtype=qint8, qscheme=torch.per_tensor_symmetric, ch_axis=-1,         scale=tensor([1.]), zero_point=tensor([0])"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       (activation_post_process): MinMaxObserver(min_val=tensor([]), max_val=tensor([]))"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     (weight_fake_quant): FakeQuantize("})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       fake_quant_enabled=tensor([1], dtype=torch.uint8), observer_enabled=tensor([1], dtype=torch.uint8),            quant_min=-128, quant_max=127, dtype=qint8, qscheme=torch.per_channel_symmetric, ch_axis=0,         scale=tensor([1., 1., 1.]), zero_point=tensor([0, 0, 0])"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#       (activation_post_process): MinMaxObserver(min_val=tensor([]), max_val=tensor([]))"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#     )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"#   )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"train"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"set_fake_quantize"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(qat_model, FakeQuantState.QAT)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" _ "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    ret "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"qat_model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"train_example_input)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    ret"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"backward"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsx)(n.li,{children:"When dynamic code blocks involve operator replacement or fusion, they must be marked with Tracer.dynamic_block. Otherwise, it will lead to quantization information confusion or forward errors."}),"\n",(0,i.jsx)(n.li,{children:"Parts of the model where the call count changes (sub-modules or dynamic blocks), if only executed once during the trace, may get fused with non-dynamic parts, leading to forward errors."}),"\n"]})})]}),"\n",(0,i.jsx)(n.p,{children:"When using the graph-based prepare method, it's recommended that the model only contains deployment logic."}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-py",meta:"",children:[(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The execution path is controlled by `training` or other flags, which may not match the final deployment state."})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# This can easily lead to misplaced quant and dequant nodes."})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"forward"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"gt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    conv_out "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"conv"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"training"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"loss"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(conv_out, gt)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"else"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sigmoid"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(conv_out)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Extract deployment logic and only apply prepare to this part."})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"forward_infer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"gt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    conv_out "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"conv"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sigmoid"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(conv_out),"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" conv_out"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Non-deployment logic is handled externally and excluded from prepare."})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"forward"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"gt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    sig_out"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" conv_out "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"forward_infer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", gt)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"training"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"loss"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(conv_out, gt)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"else"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" sig_out"})]}),"\n"]})})}),"\n",(0,i.jsx)(n.p,{children:"If it\u2019s not feasible to extract clean deployment logic due to readability or maintainability concerns, then the following checks should be performed:"}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Check for missing or unexpected keys when loading the checkpoint. Missing or unexpected quantization parameters may indicate that some deployment logic was not quantized or some non-deployment logic was incorrectly quantized. Missing or unexpected model parameters may indicate a mismatch between the forward logic used during prepare and the one used when the checkpoint was generated."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Check whether the FX graph generated by multiple prepare runs is consistent. Inconsistent FX graphs suggest that the forward logic differs across runs, and it should be verified whether this is intended."}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.h2,{id:"model-check",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model-check",children:"#"}),"Model Check"]}),"\n",(0,i.jsx)(n.p,{children:"When example_inputs is provided, prepare will perform a model structure check by default. If the check completes, a model_check_result.txt file can be found in the running directory. If the check fails, you need to modify the model based on the warning prompts or call horizon_plugin_pytorch.utils.check_model.check_qat_model separately to check the model. The check process is the same as check_qat_model in the debug tool, and the analysis of the result file is detailed in the check_qat_model related documentation."})]})}function o(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,r.ah)(),e.components);return n?(0,i.jsx)(n,Object.assign({},e,{children:(0,i.jsx)(l,e)})):l(e)}n.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fplugin%2Fuser_guide%2Fprepare.mdx"]={toc:[{id:"definition-of-prepare",text:"Definition of Prepare",depth:2},{id:"preparemethod",text:"PrepareMethod",depth:2},{id:"example",text:"Example",depth:2},{id:"model-check",text:"Model Check",depth:2}],title:"Prepare in Detail",frontmatter:{}}}}]);