"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["5790"],{61878:function(e,s,n){e.exports=n.p+"static/image/app_optimization_1.163ebda9.png"},21570:function(e,s,n){e.exports=n.p+"static/image/app_optimization_2.87003d11.png"},17251:function(e,s,n){n.r(s);var i=n(85893),r=n(50065),l=n(61878),o=n(21570);function t(e){let s=Object.assign({h1:"h1",a:"a",h2:"h2",p:"p",div:"div",ul:"ul",li:"li",strong:"strong",code:"code",pre:"pre",span:"span",h3:"h3"},(0,r.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(s.h1,{id:"model-inference-application-development-guide",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-inference-application-development-guide",children:"#"}),"Model Inference Application Development Guide"]}),"\n",(0,i.jsxs)(s.h2,{id:"overview",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#overview",children:"#"}),"Overview"]}),"\n",(0,i.jsx)(s.p,{children:"This section introduces how to develop model inference applications on the Horizon platform and highlights relevant considerations you need to be aware of."}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsxs)(s.p,{children:["Prior to the application development, make sure that you have completed the development environment preparations as described in ",(0,i.jsx)(s.a,{href:"/latest/en/guide/env_install.html",children:"Environment Deployment"})," ."]})})]}),"\n",(0,i.jsx)(s.p,{children:"The simplest application development can be divided into 3 stages: project creation, project implementation, and project compilation and operation."}),"\n",(0,i.jsx)(s.p,{children:"However, given the fact that the development of actual business scenarios are more complicated, we also provide explanations on multi-model control concepts and suggestions on application tuning."}),"\n",(0,i.jsxs)(s.h2,{id:"create_your_project",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#create_your_project",children:"#"}),"Project Creation"]}),"\n",(0,i.jsx)(s.p,{children:"We recommend using CMake to manage your application development engineering."}),"\n",(0,i.jsx)(s.p,{children:"As described in the previous sections, by now, you should have installed CMake. Before reading this section, we assume that you understand how to use CMake."}),"\n",(0,i.jsx)(s.p,{children:"The Horizon Development Library provides relevant project dependencies. The specific dependencies are listed below:"}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:["Horizon deployment library ",(0,i.jsx)(s.strong,{children:"libdnn.so"})," and ",(0,i.jsx)(s.strong,{children:"libucp.so"})," under ",(0,i.jsx)(s.code,{children:"${OE_DIR}/samples/ucp_tutorial/deps_aarch64/ucp/"}),"."]}),"\n",(0,i.jsxs)(s.li,{children:["The ",(0,i.jsx)(s.strong,{children:"aarch64-none-linux-gnu-gcc"})," C compiler."]}),"\n",(0,i.jsxs)(s.li,{children:["The ",(0,i.jsx)(s.strong,{children:"aarch64-none-linux-gnu-g++"})," C++ compiler."]}),"\n"]}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive info",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsxs)(s.p,{children:["The $"," {OE_DIR} "," above refers to the OE package path provided by Horizon."]})})]}),"\n",(0,i.jsxs)(s.p,{children:["To create a new project, you need to compile the ",(0,i.jsx)(s.code,{children:"CMakeLists.txt"})," file."]}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"CMakeLists.txt"})," file defines some compilation options, as well as the path to the dependency libs and header files, as follows:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"cmake_minimum_required(VERSION"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"project(your_project_name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# libdnn.so depends on system software dynamic link library, use -Wl,-unresolved-symbols=ignore-in-shared-libs to shield during compilation"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(CMAKE_CXX_FLAGS "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"${CMAKE_CXX_FLAGS} -std=c++11 -Wl,-unresolved-symbols=ignore-in-shared-libs"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(CMAKE_CXX_FLAGS_DEBUG "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'" -Wall -Werror -g -O0 "'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(CMAKE_C_FLAGS_DEBUG "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'" -Wall -Werror -g -O0 "'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(CMAKE_CXX_FLAGS_RELEASE "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'" -Wall -Werror -O3 "'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(CMAKE_C_FLAGS_RELEASE "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'" -Wall -Werror -O3 "'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"NOT"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"CMAKE_BUILD_TYPE"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(CMAKE_BUILD_TYPE "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"Release"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"endif"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"message("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"STATUS"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Build type: ${CMAKE_BUILD_TYPE}"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# define dnn lib path"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(DNN_PATH "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"${OE_DIR}/samples/ucp_tutorial/deps_aarch64/ucp/"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"set"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(DNN_LIB_PATH ${DNN_PATH}"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"/lib"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"include_directories($"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"{DNN_PATH}"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"/include"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"link_directories($"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"{DNN_LIB_PATH})"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"add_executable(user_app"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"main.cc"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"target_link_libraries(user_app"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                      "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"dnn"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                      "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ucp"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                      "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"pthread"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                      "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"rt"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                      "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"dl"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive info",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsxs)(s.p,{children:["In the above sample, we did not specify the compiler location. We will specify it at the project compilation stage, as described in the section ",(0,i.jsx)(s.a,{href:"#compile_and_run",children:"Project Compilation and Running"})," ."]})})]}),"\n",(0,i.jsxs)(s.h2,{id:"project-implementation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#project-implementation",children:"#"}),"Project Implementation"]}),"\n",(0,i.jsxs)(s.p,{children:["This section explains you how to run the ",(0,i.jsx)(s.code,{children:"hbm"})," models on Horizon platforms."]}),"\n",(0,i.jsx)(s.p,{children:"The simplest procedure consists of model loading, input data preparations, output memory preparations, inference and result parsing.\r\nThe sample code for simple model deployment are as follows:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-cpp",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<iostream>"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/dnn/hb_dnn.h"'})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hb_ucp.h"'})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hb_ucp_sys.h"'})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"main"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" argc"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"char"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"**"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"argv) {"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 1: Load the model"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"hbDNNPackedHandle_t"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" packed_dnn_handle;"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"const"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"char*"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" model_file_name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./mobilenetv1/mobilenetv1_224x224_nv12.hbm"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNInitializeFromFiles"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"packed_dnn_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"model_file_name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 2: Get model names"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"const"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"char"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"**"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"model_name_list;"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" model_count "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetModelNameList"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"model_name_list"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"model_count"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" packed_dnn_handle);"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 3: Get dnn_handle"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"hbDNNHandle_t"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle;"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetModelHandle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"dnn_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" packed_dnn_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"model_name_list"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"]);"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 4: Prepare input data"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" input_count "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetInputCount"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"input_count"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle);"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  std"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"vector"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"hbDNNTensor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(input_count);"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"; i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" input_count; i"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") {"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetInputTensorProperties"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[i]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"properties"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i);"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"auto"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"mem "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[i]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem;"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"    /*"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"      1. For dynamic input, you need to set the corresponding dynamic parameters in input[i].properties."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"      2. Call hbUCPMalloc/hbUCPMallocCached to apply for the corresponding memory size based on the model input."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"         such as hbUCPMallocCached(&mem, size, 0);"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"      3. Determine whether the input needs quantization or padding based on properties, then fill the input data into mem."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"      4. If the memory is a cacheable, you must actively perform a flush operation after writing."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"         such as hbUCPMemFlush(&mem, HB_SYS_MEM_CACHE_CLEAN); "})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"    */"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 5: Prepare storage space for the output data of the model"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" output_count "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetOutputCount"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"output_count"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle);"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  std"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"vector"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"hbDNNTensor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"output"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(output_count);"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"; i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" output_count; i"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") {"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    hbDNNTensorProperties "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"output_properties "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[i]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"properties;"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetOutputTensorProperties"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"output_properties"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i);"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" out_aligned_size "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"output_properties"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"alignedByteSize;"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    hbUCPSysMem "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"mem "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[i]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem;"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMallocCached"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"mem"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" out_aligned_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 6: Create the asynchronous inference task"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"hbUCPTaskHandle_t"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" task_handle{"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"nullptr"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"};"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNInferV2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"task_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"               "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"data"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"()"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"               "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"data"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"()"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"               dnn_handle);"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 7: Submit the task"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  hbUCPSchedParam infer_sched_param;"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"HB_UCP_INITIALIZE_SCHED_PARAM"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"infer_sched_param);"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPSubmitTask"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"infer_sched_param);"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 8: Wait for the task to end"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPWaitTaskDone"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Step 9: Parse model output, here we take the classification model as an example to get the top1 result"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"; i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" output_count; i"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") {"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"    // For output memory that applies for the cacheable attribute, it needs to be actively flushed before reading."})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMemFlush"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[i]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem)"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" HB_SYS_MEM_CACHE_INVALIDATE);"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"    /*"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"       1. Determine whether the output data has padding, whether inverse quantization is required, and the quantization parameter information required for inverse quantization, etc."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"       2. parsing process."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"    */"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Release the task"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPReleaseTask"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle);"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Release the memory"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"; i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" input_count; i"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") {"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPFree"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[i]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem));"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"; i "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" output_count; i"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") {"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPFree"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[i]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem));"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Release the model"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNRelease"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"(packed_dnn_handle);"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"To keep it simple, part of the model processing in above sample is described in the form of comments. More details are explained in subsequent documents, such as:"}),"\n",(0,i.jsxs)(s.p,{children:["For dynamic input instructions, please refer to section ",(0,i.jsx)(s.a,{href:"/latest/en/guide/ucp/runtime/bpu_sdk_api/dynamic_input_introduction.html",children:"Dynamic Input Instruction"}),"."]}),"\n",(0,i.jsxs)(s.p,{children:["For memory alignment rules, please refer to section ",(0,i.jsx)(s.a,{href:"/latest/en/guide/ucp/runtime/bpu_sdk_api/alignment_rule.html",children:"Alignment Rule"}),"."]}),"\n",(0,i.jsxs)(s.p,{children:["For more comprehensive instructions on the engineering implementation, refer to sections ",(0,i.jsx)(s.a,{href:"/latest/en/guide/ucp/runtime/bpu_sdk_api/bpu_sdk_api_overview.html",children:"Model Inference API Instruction"})," and ",(0,i.jsx)(s.a,{href:"/latest/en/guide/ucp/runtime/basic_sample.html",children:"Basic Sample User Guide"}),"."]}),"\n",(0,i.jsxs)(s.h2,{id:"compile_and_run",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#compile_and_run",children:"#"}),"Project Compilation and Running"]}),"\n",(0,i.jsxs)(s.p,{children:["Combining with CMake engineering configurations as described in ",(0,i.jsx)(s.a,{href:"#create_your_project",children:"Project Creation"}),", please refer to the following compilation script:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Define gcc path for ARM"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"LINARO_GCC_ROOT"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"/usr"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"DIR"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"$("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:' "$('}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"dirname"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:' "$0")";'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"pwd"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"export"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" CC"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"${LINARO_GCC_ROOT}"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"/bin/aarch64-none-linux-gnu-gcc"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"export"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" CXX"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"${LINARO_GCC_ROOT}"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"/bin/aarch64-none-linux-gnu-g++"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"rm"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"-rf"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"build_arm"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"mkdir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"build_arm"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"build_arm"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"cmake"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${DIR}"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"make"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"-j8"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["After reading ",(0,i.jsx)(s.a,{href:"/latest/en/guide/env_install.html",children:"Environment Deployment"}),", we assume that you have installed the required compiler on your dev PC,\r\nso here you only need to associate the compiler configurations in the above script with your project."]}),"\n",(0,i.jsxs)(s.p,{children:["Copy the arm program to the Horizon board to run, note that the program dependencies also need to be copied to the board together, and configure the dependencies in the startup script.\r\nFor example, our sample program depends on the following libraries: ",(0,i.jsx)(s.code,{children:"libhbucp.so, libdnn.so"})," and other bsp libraries.\r\nThese dependencies can be found in the OE package under the path ",(0,i.jsx)(s.code,{children:"ucp_tutorial/deps_aarch64/"})," and need to be uploaded to the board's runtime environment.\r\nWe recommend that you create a new ",(0,i.jsx)(s.code,{children:"lib"})," path under the ",(0,i.jsx)(s.code,{children:"/userdata"})," path on the board side and transfer the libraries to that directory, the paths to the dependency libraries that need to be specified before running the program on the board side are as follows:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"export"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" LD_LIBRARY_PATH"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"$LD_LIBRARY_PATH"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:":/userdata/lib"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h2,{id:"multi-model-control-strategy",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#multi-model-control-strategy",children:"#"}),"Multi-model Control Strategy"]}),"\n",(0,i.jsx)(s.p,{children:"In the scenarios containing multiple models, as each model need to complete the inference with limited resources, they will inevitably compete for computing resources."}),"\n",(0,i.jsx)(s.p,{children:"To help you control the execution of multiple models, we provide control strategies for the model prioritization."}),"\n",(0,i.jsxs)(s.h3,{id:"preemption",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#preemption",children:"#"}),"Model Preemption Control"]}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsx)(s.p,{children:"This feature is only supported on the dev board side and is not supported by the x86 simulator."})})]}),"\n",(0,i.jsx)(s.p,{children:"There isn't task preemption feature in the BPU computing unit hardware of the S100 ASIC.\r\nEach inference task, once put to the BPU and begins model computing, it occupies the BPU until the task is completed.\r\nAt this time, other tasks have to wait in line. If the BPU is occupied by a large model inference task, then other high-priority model inference tasks cannot be executed."}),"\n",(0,i.jsx)(s.p,{children:"To fix this, we added a software feature called BPU Resource Preemption in the Runtime SDK based on model priorities."}),"\n",(0,i.jsx)(s.p,{children:"Pay attention to the following:"}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"When executing inference in BPU, the compiled data command model is denoted by 1 or more function calls. The function call means the atomic execution unit of the BPU, and multiple function-call tasks are queued in the hardware queue and processed in turn.\r\nA model inference task will be considered done when all of it function calls are executed."}),"\n",(0,i.jsx)(s.li,{children:"Based on the above descriptions, it is simpler to set the function call as the preemption granularity of the BPU model task, that is, when the BPU finishes a function call, it can temporarily suspend the existing model, switch to another model, and then resume it when the latter is done.\r\nHowever, there are 2 problems, the first is that the function calls of the model compiled by the compiler are merged together to form a large function call and cannot be preempted.\r\nThe second problem is that the execution time of each function call is relatively long or not fixed, which leads to unfixed preemption timing, affecting the preemption results."}),"\n"]}),"\n",(0,i.jsx)(s.p,{children:"To solve these two problems, we provide supports in both model conversion and system software. The implementation principles and operation methods are as follows:"}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:["Firstly, if you choose to process the model using the QAT scheme, then at the ",(0,i.jsx)(s.strong,{children:"model compilation"})," stage, you need to add the ",(0,i.jsx)(s.code,{children:"max_time_per_fc"})," option to the extra parameter configurations in the compilation interface to set the execution time (in microseconds) for each function call.\r\nThe default value is ",(0,i.jsx)(s.code,{children:"0"})," (no limits). By setting this option, you can control the execution time of individual large function calls when they are running on-board.\r\nSuppose the execution time of a function call is ",(0,i.jsx)(s.code,{children:"10ms"}),", and ",(0,i.jsx)(s.code,{children:"max_time_per_fc"})," is set to ",(0,i.jsx)(s.code,{children:"1000"})," during model compilation, then this function call will be split into 10 function calls.\r\nIf you are using the PTQ scheme to process the model, you can add the ",(0,i.jsx)(s.code,{children:"max_time_per_fc"})," parameter to the compiler-related parameters (",(0,i.jsx)(s.code,{children:"compiler_parameters"}),") in the YAML configuration file of the model at the ",(0,i.jsx)(s.strong,{children:"model conversion"})," stage."]}),"\n",(0,i.jsxs)(s.li,{children:["Secondly, the ",(0,i.jsx)(s.code,{children:"hbUCPSchedParam.priority"})," parameter needs to be set when the reasoning task is submitted. High-optimization preemption nesting capabilities can also be supported according to priority.\r\nFor example, if you configure the ",(0,i.jsx)(s.code,{children:"infer"})," task with a priority less than ",(0,i.jsx)(s.code,{children:"254"}),", it is a normal task and cannot preempt other tasks.\r\nConfigure ",(0,i.jsx)(s.code,{children:"infer"})," task with a priority equal to ",(0,i.jsx)(s.code,{children:"254"})," to be a high preemption task, which can support preemption of normal tasks.\r\nConfigure ",(0,i.jsx)(s.code,{children:"infer"})," task with a priority equal to ",(0,i.jsx)(s.code,{children:"255"})," to be a urgent preemptive task, which can preempt both normal and high preemptive tasks."]}),"\n",(0,i.jsx)(s.li,{children:"Finally, it should be noted that the BPU preemption function is system-level, that is, the preemption task submitted by the current process can not only preempt normal tasks within the process, but also preempt normal tasks of other processes."}),"\n"]}),"\n",(0,i.jsxs)(s.h2,{id:"suggestions-on-application-optimization",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#suggestions-on-application-optimization",children:"#"}),"Suggestions on Application Optimization"]}),"\n",(0,i.jsx)(s.p,{children:"Horizon suggested application optimization strategy includes Engineering Task Scheduling and Algorithm Task Integration."}),"\n",(0,i.jsxs)(s.p,{children:["For ",(0,i.jsx)(s.strong,{children:"Engineering Task Scheduling"}),", we recommend some workflow scheduling management tools to fully utilize the parallel-processing capabilities at different task stages."]}),"\n",(0,i.jsx)(s.p,{children:"In general, an application can be divided into 3 stages: pre-processing, model inference, and post-processing output."}),"\n",(0,i.jsx)(s.p,{children:"A simplified workflow is as follows:"}),"\n",(0,i.jsx)("img",{src:l,alt:"app_optimization_1",height:"800",width:"800"}),"\n",(0,i.jsx)(s.p,{children:"After making full use of the workflow management to achieve the parallel execution of different task stages, the ideal task processing workflow can be as follows:"}),"\n",(0,i.jsx)("img",{src:o,alt:"app_optimization_2",height:"800",width:"800"}),"\n",(0,i.jsxs)(s.p,{children:["For ",(0,i.jsx)(s.strong,{children:"Algorithm Task Integration"}),", we recommend multi-task models."]}),"\n",(0,i.jsx)(s.p,{children:"On one hand, it can avoid the difficulties brought by the management of multi-model scheduling to a certain extent."}),"\n",(0,i.jsx)(s.p,{children:"On the other hand, as multi-task model can fully share the computation of the backbone, it can significantly reduce the amount of computation at the entire application level compared to using independent models, and thereby achieve higher overall performance."}),"\n",(0,i.jsx)(s.p,{children:"Multitasking is also a common application-level optimization strategy within Horizon Robotics and in the business practices of many collaborating customers."}),"\n",(0,i.jsxs)(s.h2,{id:"other-dev-tools",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#other-dev-tools",children:"#"}),"Other Dev Tools"]}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"hrt_model_exec"})," is a model execution tool that can evaluate the inference performance of the model and get the model information directly on the dev board.\r\nOn one hand, it allows you to get a realistic understanding of the model's real performance; On the other hand, it also helps you to learn the speed limit that the model can achieve, which is useful information in application tuning."]}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"hrt_model_exec"})," provides three types of functions including model inference ",(0,i.jsx)(s.code,{children:"infer"}),", model performance analysis ",(0,i.jsx)(s.code,{children:"perf"})," and viewing model information ",(0,i.jsx)(s.code,{children:"model_info"}),". For how to use the tool, please refer to ",(0,i.jsx)(s.a,{href:"/latest/en/guide/ucp/runtime/tool_introduction/hrt_model_exec.html",children:"hrt_model_exec Tool Introduction"}),"."]}),"\n",(0,i.jsxs)(s.p,{children:["UCP also provides performance analysis tools to assist you in locating application performance bottlenecks. Among them, ",(0,i.jsx)(s.code,{children:"UCP Trace"})," is used to analyze the application pipline scheduling capability, and ",(0,i.jsx)(s.code,{children:"hrt_ucp_monitor"})," is used to monitor the occupancy rate of the hardware backend."]}),"\n",(0,i.jsxs)(s.p,{children:["Please refer to the section ",(0,i.jsx)(s.a,{href:"/latest/en/guide/ucp/ucp_tools/ucp_trace.html",children:"UCP Trace Instructions"})," and ",(0,i.jsx)(s.a,{href:"/latest/en/guide/ucp/ucp_tools/ucp_monitor.html",children:"The hrt_ucp_monitor Tool Introduction"})," for how to use these tools."]})]})}function a(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:s}=Object.assign({},(0,r.ah)(),e.components);return s?(0,i.jsx)(s,Object.assign({},e,{children:(0,i.jsx)(t,e)})):t(e)}s.default=a,a.__RSPRESS_PAGE_META={},a.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fucp%2Fruntime%2Fruntime_dev.mdx"]={toc:[{id:"overview",text:"Overview",depth:2},{id:"create_your_project",text:"Project Creation",depth:2},{id:"project-implementation",text:"Project Implementation",depth:2},{id:"compile_and_run",text:"Project Compilation and Running",depth:2},{id:"multi-model-control-strategy",text:"Multi-model Control Strategy",depth:2},{id:"preemption",text:"Model Preemption Control",depth:3},{id:"suggestions-on-application-optimization",text:"Suggestions on Application Optimization",depth:2},{id:"other-dev-tools",text:"Other Dev Tools",depth:2}],title:"Model Inference Application Development Guide",frontmatter:{}}}}]);