"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["6667"],{63921:function(e,s,n){e.exports=n.p+"static/image/prepare_calibration_data.3f8f0262.png"},33067:function(e,s,n){n.r(s);var r=n(85893),i=n(50065),o=n(63921);function l(e){let s=Object.assign({h1:"h1",a:"a",p:"p",strong:"strong",h2:"h2",div:"div",code:"code",ul:"ul",li:"li",ol:"ol",pre:"pre",span:"span",h3:"h3",h4:"h4"},(0,i.ah)(),e.components);return(0,r.jsxs)(r.Fragment,{children:[(0,r.jsxs)(s.h1,{id:"data-preparation",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#data-preparation",children:"#"}),"Data Preparation"]}),"\n",(0,r.jsx)(s.p,{children:"Before calibration and inference of the model, it is necessary to perform data preprocessing operations to meet the requirements of the model.\nThis requires us to do some data preparation, below we will detail the steps for model calibration set and inference preparation respectively."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Model calibration set preparation"}),": Since the accuracy of the model calibration process is closely related to the correctness of the input data,\nin order to obtain correct calibration results and ensure the accuracy and effect of the calibrated model, we need to prepare the model calibration set."]}),"\n",(0,r.jsx)(s.p,{children:"This process requires the use of samples similar to those in the training or validation set and ensures that the calibration samples undergo data preprocessing consistent with the original floating-point model,\nso as to ensure the consistency of data type, shape, and layout."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Model inference preparation"}),": ",(0,r.jsx)(s.a,{href:"/latest/en/guide/ptq/ptq_tool/hbruntime.html",children:"HBRuntime"})," supports a variety of model inference scenarios (ONNX model, HBIR model and HBM model).\nIn order to ensure correct inference results, the input data used in the inference process need to be preprocessed and converted as necessary to meet the model requirements."]}),"\n",(0,r.jsx)(s.p,{children:"For example, Pyramid input, Resizer input, and multiple Batch splitting scenarios will lead to changes in the model structure and require corresponding processing and data preparation."}),"\n",(0,r.jsx)(s.p,{children:"Next, we will introduce the processing and data preparation required before calibration/inference of the model from each of these two aspects."}),"\n",(0,r.jsxs)(s.h2,{id:"prepare_calibration_data",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#prepare_calibration_data",children:"#"}),"Model Calibration Set Preparation"]}),"\n",(0,r.jsxs)(s.div,{className:"rspress-directive info",children:[(0,r.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,r.jsx)(s.div,{className:"rspress-directive-content",children:(0,r.jsxs)(s.p,{children:["If you need to do this process in the sample folder, you need to execute the ",(0,r.jsx)(s.code,{children:"00_init.sh"})," script in the folder first to get the corresponding original model and dataset."]})})]}),"\n",(0,r.jsx)(s.p,{children:"When performing model calibration, 20~100 samples are required at the calibration stage, each is an independent data file.\nTo ensure the accuracy of the calibrated models, these calibration samples better come from the training or validation dataset when training the models.\nIn addition, please try NOT to use rare samples, e.g. single colored images or those images that don't contain any detection or classification targets in them."}),"\n",(0,r.jsxs)(s.p,{children:["You need to preprocess the samples from the training/verification sets (the preprocessing process is the same as the original floating-point model data preprocessing process),\nand the calibrated samples after processing will have the same data type (",(0,r.jsx)(s.code,{children:"input_type_train"}),"), shape (",(0,r.jsx)(s.code,{children:"input_shape"}),") and layout (",(0,r.jsx)(s.code,{children:"input_layout _train"}),") with the original floating-point model.\nYou can save the data as an npy file with the ",(0,r.jsx)(s.code,{children:"numpy.save"})," command, and the toolchain will read it based on the ",(0,r.jsx)(s.code,{children:"numpy.load"})," command when it is calibrated.\nThe basic flow of the data set for pre-processing is shown below:"]}),"\n",(0,r.jsx)("img",{src:o,alt:"prepare_calibration_data",width:"900"}),"\n",(0,r.jsx)(s.p,{children:"For example, there is an ImageNet trained original classification floating-point model with only one input node, it should be described as below:"}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsxs)(s.li,{children:["Input type: ",(0,r.jsx)(s.code,{children:"BGR"}),"."]}),"\n",(0,r.jsxs)(s.li,{children:["Input layout: ",(0,r.jsx)(s.code,{children:"NCHW"}),"."]}),"\n",(0,r.jsxs)(s.li,{children:["Input shape: ",(0,r.jsx)(s.code,{children:"1x3x224x224"}),"."]}),"\n"]}),"\n",(0,r.jsx)(s.p,{children:"The steps for data preprocessing of the original floating point model are as follows:"}),"\n",(0,r.jsxs)(s.ol,{children:["\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"Uniformly scale the image and resize the shorter side to 256."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:["Get 224x224 image using the ",(0,r.jsx)(s.code,{children:"center_crop"})," method."]}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:["Align the input layout to the ",(0,r.jsx)(s.code,{children:"NCHW"})," required by the model."]}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:["Convert the color space to the ",(0,r.jsx)(s.code,{children:"BGR"})," required by the model."]}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"Adjust the range of image values to [0, 255] as required by the model."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"Subtract mean value by the channel."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"Data multiple by the scale factor."}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:["The sample processing code for the above example model is as follows (to avoid excessive code length, some simple transformer implementation codes are ignored, the usage of transformer can be found in ",(0,r.jsx)(s.a,{href:"/latest/en/guide/ptq/ptq_appendix/transformer.html",children:"Image Processing"}),")."]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# this sample uses skimage, mind the differences when using opencv/PIL"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" skimage"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" skimage"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"io"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_tc_ui"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"transformer "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" (CenterCropTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            HWC2CHWTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            MeanTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            RGB2BGRTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            ScaleTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            ShortSideResizeTransformer)"})}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"data_transformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"():"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    transformers "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ["})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# uniformly scale the image and resize the shorter side to 256"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ShortSideResizeTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(short_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# get 224x224 image using the CenterCrop"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"CenterCropTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(crop_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# read the NHWC layout results using the skimage and convert into the model required NCHW layout"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"HWC2CHWTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(),"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# read the RGB channel sequence results using the skimage and convert into the model required BGR"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2BGRTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(),"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# read the value range between [0.0,1.0] using the skimage and adjust into the model required value range"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ScaleTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(scale_value"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"255"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# for all pixels in the input image, subtract mean_value"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"MeanTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(means"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"np."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"103.94"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"116.78"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"123.68"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"])),"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# for all pixels in the input image, multiple by the data_scale factor"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ScaleTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(scale_value"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.017"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    ]"})}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" transformers"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# the src_image refers to the source images in sample dataset"})}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# the dst_file refers to the filename to save the final sample datasets"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"convert_image"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"src_image"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"dst_file"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"transformers"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    image "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" [skimage"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"img_as_float"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        skimage.io."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"imread"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(src_image))."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.float32)"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" trans "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" transformers"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        image "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"trans"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"#  type of input_type_train BGR value specified by the model is UINT8"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    image "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Save calibration samples into a data file in binary format"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    np"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"save"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(dst_file, image)"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'__main__'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# refer to the original sample images, fake-code"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    src_images "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'ILSVRC2012_val_00000001.JPEG'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ...]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# denote the filename (no restrictions on suffix) of the final samples, fake-code"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# calibration_data_bgr refers to your specified cal_data_dir in the configuration file"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    dst_files "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'./calibration_data_bgr/ILSVRC2012_val_00000001.npy'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ...]"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    transformers "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"data_transformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" src_image"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" dst_file "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"zip"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(src_images, dst_files):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"convert_image"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(src_image, dst_file, transformers)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,r.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,r.jsxs)(s.div,{className:"rspress-directive-content",children:[(0,r.jsx)(s.p,{children:"Note that the input_shape parameter in the yaml file serves to specify the input data size of the original floating-point model.\nIf it is a dynamic input model, you can use this parameter to set the converted input size, and the shape size of the calibration data should be consistent with input_shape."}),(0,r.jsx)(s.p,{children:'For example, if the original floating-point model input node shape is ?x3x224x224 ("?" sign represents the placeholder, i.e., the first dimension of the model is dynamic input), and the input_shape: 8x3x224x224 is set in the conversion profile,\nthen the size of each calibration data that you need to prepare is 8x3x224x224 (Please be aware that the input_batch parameter does not support modifying the model batch information for models with the first dimension of the input shape not equal to 1).'})]})]}),"\n",(0,r.jsxs)(s.h2,{id:"model-inference-preparation",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-inference-preparation",children:"#"}),"Model Inference Preparation"]}),"\n",(0,r.jsx)(s.p,{children:"As mentioned above, to ensure that the input data meets the model requirements, the input data needs to be processed accordingly before model inference.\nIn the following, we will introduce you the data preparation before model inference for ONNX model inference and HBIR/HBM model inference respectively."}),"\n",(0,r.jsxs)(s.h3,{id:"onnx-model-inference-preparation",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#onnx-model-inference-preparation",children:"#"}),"ONNX Model Inference Preparation"]}),"\n",(0,r.jsx)(s.p,{children:"After the graph optimization and calibration process, the input data of the generated ONNX models\n(*_optimized_float_model.onnx, *_calibrated_model.onnx, and *_ptq_model.onnx) have been kept consistent with the inputs of the original floating-point model."}),"\n",(0,r.jsxs)(s.p,{children:["If you have not configured the ",(0,r.jsx)(s.code,{children:"input_batch"})," parameter in the yaml file, just make sure that the input data is the same as the original floating point model."]}),"\n",(0,r.jsxs)(s.p,{children:["If you have configured the ",(0,r.jsx)(s.code,{children:"input_batch"})," parameter in the yaml file and set it to 8,\nand the original model input shape is ",(0,r.jsx)(s.code,{children:"1x3x224x224"}),",\nthen the input shape of the ptq_model.onnx model that is generated during the compilation and conversion process is ",(0,r.jsx)(s.code,{children:"8x3x224x224"}),".\nAt this point, you need to prepare the input data according to the input shape of ",(0,r.jsx)(s.code,{children:"8x3x224x224"}),"."]}),"\n",(0,r.jsxs)(s.h3,{id:"hbirhbm-model-inference-preparation",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#hbirhbm-model-inference-preparation",children:"#"}),"HBIR/HBM Model Inference Preparation"]}),"\n",(0,r.jsx)(s.p,{children:"Since the HBIR/HBM model may be modified during the conversion and compilation process,\nthese modifications may cause the model's requirements for input data to change as well."}),"\n",(0,r.jsx)(s.p,{children:"Therefore, the input data required by the model needs to be processed before model inference,\nand below we give several common scenarios for input data preparation."}),"\n",(0,r.jsxs)(s.h4,{id:"data-preprocessing-scenario",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#data-preprocessing-scenario",children:"#"}),"Data Preprocessing Scenario"]}),"\n",(0,r.jsxs)(s.p,{children:["If you have configured ",(0,r.jsx)(s.code,{children:"input_type_rt"})," (in case of inconsistency with ",(0,r.jsx)(s.code,{children:"input_type_train"}),"),\n",(0,r.jsx)(s.code,{children:"mean_value"}),", and ",(0,r.jsx)(s.code,{children:"scale_value/std_value"})," parameters in the yaml file, the model will do the color transformations and normalization,\nand you only need to prepare the data according to ",(0,r.jsx)(s.code,{children:"input_type_rt"})," data type for data preparation and no normalization is required."]}),"\n",(0,r.jsxs)(s.h4,{id:"pyramid-input-scenario",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#pyramid-input-scenario",children:"#"}),"Pyramid Input Scenario"]}),"\n",(0,r.jsxs)(s.p,{children:["If you have configured the ",(0,r.jsx)(s.code,{children:"input_type_rt"})," parameter and set it to nv12 or gray,\nor set the ",(0,r.jsx)(s.code,{children:"input_source"})," parameter to pyramid in the yaml file,\nit will be regarded as a Pyramid input scenario."]}),"\n",(0,r.jsx)(s.p,{children:"The Pyramid input scenario refers to the input scenario in the form of YUV420SP (NV12).\nThe data preparation steps are as follows:"}),"\n",(0,r.jsxs)(s.ol,{children:["\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"(If necessary) Resize the image to the appropriate size."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"The original input type needs to be converted to the NV12 data type that the model requires."}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,r.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,r.jsx)(s.div,{className:"rspress-directive-content",children:(0,r.jsxs)(s.p,{children:["If you configure parameters such as ",(0,r.jsx)(s.code,{children:"mean_value"})," and ",(0,r.jsx)(s.code,{children:"scale_value/std_value"})," in the yaml configuration file,\nno further normalization is required during the data preparation phase."]})})]}),"\n",(0,r.jsxs)(s.p,{children:["When using the Pyramid input, it will be split into Y and UV channels for shape input in order to better process the image data.\nFor example, if the original model input shape is ",(0,r.jsx)(s.code,{children:"1x3x224x224"}),", when inserting Pyramid input,\nthe required input_y shape is ",(0,r.jsx)(s.code,{children:"1x224x224x1"})," and input_uv shape is ",(0,r.jsx)(s.code,{children:"1x112x112x2"}),".\nThe following code takes RGB data type to NV12 data type as an example for your reference, in the actual use scenario, please replace it as needed."]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"rgb_to_nv12"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"array):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    b "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.299"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.587"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.114"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" b)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    u "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.169"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.331"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" b "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    v "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.419"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.081"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" b "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"zeros"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(shape"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"], u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"] "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"            uv"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" u"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"            uv"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" v"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" uv"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" uv"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h4,{id:"resizer-input-scenario",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#resizer-input-scenario",children:"#"}),"Resizer Input Scenario"]}),"\n",(0,r.jsxs)(s.p,{children:["If you have configured the ",(0,r.jsx)(s.code,{children:"input_source"})," parameter and set it to resizer in the yaml file, it will be regarded as a Resizer input scenario."]}),"\n",(0,r.jsx)(s.p,{children:"The Resizer input scenario refers to the scenario where the model on the BPU takes the form of YUV420SP (NV12) plus a rectangular ROI for input.\nThe data preparation steps are as follows:"}),"\n",(0,r.jsxs)(s.ol,{children:["\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"(If necessary) Resize the image to the appropriate size."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"The original input type needs to be converted to the NV12 data type that the model requires."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:["Define an input ROI (Region of Interest) and define the ROI size by the four boundaries of the ROI tensor input coordinates left, top, right and bottom.\nFor a detailed introduction to the Region of Interest (ROI), you can refer to the\nModel Deployment Practice Guidance - Model Modification - Resizer Input Insertion - ",(0,r.jsx)(s.a,{href:"/latest/en/guide/model_deployment_guidance/model_deployment_principle_process/model_modify.html#roi_introduction_constraint",children:"ROI Introduction and Constraints"})," section ."]}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,r.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,r.jsx)(s.div,{className:"rspress-directive-content",children:(0,r.jsxs)(s.p,{children:["If you configure parameters such as ",(0,r.jsx)(s.code,{children:"mean_value"})," and ",(0,r.jsx)(s.code,{children:"scale_value/std_value"})," in the yaml configuration file,\nno further normalization is required during the data preparation phase."]})})]}),"\n",(0,r.jsxs)(s.p,{children:["When using the Resizer input, it will be split into Y and UV channels for shape input in order to better process the image data, and the defined ROIs will be shaped together for input.\nFor example, if the original model input shape is ",(0,r.jsx)(s.code,{children:"1x3x224x224"}),", when inserting Resizer input,\nthe required input_y shape is ",(0,r.jsx)(s.code,{children:"1xNonexNonex1"}),", input_uv shape is ",(0,r.jsx)(s.code,{children:"1xNonexNonex2"})," and input_roi shape is ",(0,r.jsx)(s.code,{children:"1x4"}),".\nThe following code takes RGB data type to NV12 data type as an example and also includes the definition of ROI coordinates for your reference, in the actual use scenario, please replace it as needed."]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"rgb_to_nv12"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"array):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    b "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[:,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.299"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.587"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.114"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" b)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    u "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.169"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.331"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" b "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    v "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" r "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.419"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" g "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.081"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" b "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"zeros"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(shape"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"], u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"] "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", u.shape["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]):"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"            uv"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" u"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"            uv"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" v"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"i"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" j"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    y "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    uv "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" uv"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" y"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" uv"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Example of ROI coordinate definition"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"roi_data "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"([["}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", input_w "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", input_h "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]])."}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint32)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h4,{id:"multi-batch-splitting-scenario",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#multi-batch-splitting-scenario",children:"#"}),"Multi-Batch Splitting Scenario"]}),"\n",(0,r.jsxs)(s.p,{children:["If the original model is a multi-batch model , or if you have configured the ",(0,r.jsx)(s.code,{children:"input_batch"})," parameter in the yaml file\nand set the ",(0,r.jsx)(s.code,{children:"separate_batch"})," parameter to True or configure the ",(0,r.jsx)(s.code,{children:"separate_name"})," parameter to specify the split node,\nthe corresponding input node will be split internally."]}),"\n",(0,r.jsx)(s.p,{children:"For multi-batch models, after the model is split according to the batch dimensions,\neach split model input prepares its own input data according to the required input type and data layout."}),"\n",(0,r.jsxs)(s.p,{children:["For example, the original model input shape is ",(0,r.jsx)(s.code,{children:"1x3x224x224"}),", if you set the ",(0,r.jsx)(s.code,{children:"input_batch"})," parameter to 8 in the yaml file,\nthe shape of this ptq_model.onnx model will be ",(0,r.jsx)(s.code,{children:"8x3x224x224"})," after calibrating processing.\nAt this point, if the ",(0,r.jsx)(s.code,{children:"separate_batch"})," or ",(0,r.jsx)(s.code,{children:"separate_name"})," parameter is also configured in the yaml file,\nthe model will be batch split for the corresponding input.\nThe input shape of the model after splitting consists of 8 ",(0,r.jsx)(s.code,{children:"1x3x224x224"}),".\nAt this point, you need to prepare the data for each input according to the ",(0,r.jsx)(s.code,{children:"1x3x224x224"})," shape."]}),"\n",(0,r.jsxs)(s.h2,{id:"conclusion",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#conclusion",children:"#"}),"Conclusion"]}),"\n",(0,r.jsx)(s.p,{children:"The above content introduces you to the calibration set preparation of the model and the data preparation required for model inference in some typical scenarios.\nIn practice, you can refer to this chapter to prepare the input data in a targeted way."})]})}function t(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:s}=Object.assign({},(0,i.ah)(),e.components);return s?(0,r.jsx)(s,Object.assign({},e,{children:(0,r.jsx)(l,e)})):l(e)}s.default=t,t.__RSPRESS_PAGE_META={},t.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fptq%2Fptq_usage%2Fprepare_data.mdx"]={toc:[{id:"prepare_calibration_data",text:"Model Calibration Set Preparation",depth:2},{id:"model-inference-preparation",text:"Model Inference Preparation",depth:2},{id:"onnx-model-inference-preparation",text:"ONNX Model Inference Preparation",depth:3},{id:"hbirhbm-model-inference-preparation",text:"HBIR/HBM Model Inference Preparation",depth:3},{id:"data-preprocessing-scenario",text:"Data Preprocessing Scenario",depth:4},{id:"pyramid-input-scenario",text:"Pyramid Input Scenario",depth:4},{id:"resizer-input-scenario",text:"Resizer Input Scenario",depth:4},{id:"multi-batch-splitting-scenario",text:"Multi-Batch Splitting Scenario",depth:4},{id:"conclusion",text:"Conclusion",depth:2}],title:"Data Preparation",frontmatter:{}}}}]);