"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["7230"],{13475:function(e,s,n){n.r(s);var r=n(85893),i=n(50065);function a(e){let s=Object.assign({h1:"h1",a:"a",p:"p",div:"div",h2:"h2",strong:"strong",code:"code",ul:"ul",li:"li",pre:"pre",span:"span",ol:"ol"},(0,i.ah)(),e.components);return(0,r.jsxs)(r.Fragment,{children:[(0,r.jsxs)(s.h1,{id:"image-processing-transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#image-processing-transformer",children:"#"}),"Image Processing Transformer"]}),"\n",(0,r.jsx)(s.p,{children:"This section will explain the concepts and parameters of each transformer you use when scaling and cropping images, and provide you with reference to the use of samples to make it easier for you to perform transformer operations."}),"\n",(0,r.jsx)(s.p,{children:"Before reading the contents of the document, please note the following:"}),"\n",(0,r.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,r.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,r.jsx)(s.div,{className:"rspress-directive-content",children:(0,r.jsx)(s.p,{children:"The image data is three-dimensional data, but the default first dimension of the transformer provided by Horizon is N-dimensional, and it will process the data with the first dimension split cycle, so if you need to do processing on the image, please provide four-dimensional data."})})]}),"\n",(0,r.jsxs)(s.h2,{id:"addtransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#addtransformer",children:"#"}),"AddTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsxs)(s.p,{children:["Adds values to all the pixel values in the input image. The transformer converts the data format to ",(0,r.jsx)(s.code,{children:"float32"})," in the output."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"value: Value to be added to each pixel. Note that value can be negative, e.g., -128."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Subtracts 128 from the image data"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"``"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"AddTransformer(-128"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"``"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Adds 127 to the image data"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"``"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"AddTransformer(127"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"``"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"meantransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#meantransformer",children:"#"}),"MeanTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsxs)(s.p,{children:["subtracts the ",(0,r.jsx)(s.code,{children:"mean_value"})," from all pixel values in the input image."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"means: Subtracted value of each pixel. Note that the value can be a negative number, e.g., -128."}),"\n",(0,r.jsx)(s.li,{children:'data_format: Layout type of the input. Value range: ["CHW", "HWC"], defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Each pixel subtracts 128.0. Input type: CHW"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"MeanTransformer(np.array([128.0,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"]"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")) "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Each pixel subtracts a different value: 103.94, 116.78, 123.68. Input type: HWC"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"MeanTransformer(np.array([103.94,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"116.78"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"123.68"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"]"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"), data_format="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"HWC"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"scaletransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#scaletransformer",children:"#"}),"ScaleTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Multiplies all pixel values in the input image by the data_scale factor."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"scale_value: Factor to be multiplied, such as 0.0078125 or 1/128."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Adjusts all pixels within the range [-128, 127] to [-1, 1]."})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ScaleTransformer(0.0078125"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# or"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ScaleTransformer(1/128"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"normalizetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#normalizetransformer",children:"#"}),"NormalizeTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsxs)(s.p,{children:["Normalizes the input image and converts the data format to ",(0,r.jsx)(s.code,{children:"float32"})," in the output."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"std: Value by which the first input image needs to be divided."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Adjusts all pixels within the range [-128, 127] to [-1, 1]"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"NormalizeTransformer(128"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"transposetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#transposetransformer",children:"#"}),"TransposeTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Operation used to perform the layout conversion."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"order: Order of the input image after the layout conversion (the order is related to the original layout order), e.g., suppose HWC order is (0,1,2), when converted to CHW, the order is (2,0,1)."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# HWC to CHW"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"TransposeTransformer((2,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"))"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# CHW to HWC"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"TransposeTransformer((1,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"))"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"hwc2chwtransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#hwc2chwtransformer",children:"#"}),"HWC2CHWTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts NHWC to NCHW."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),": None."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# NHWC to NCHW"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"HWC2CHWTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"chw2hwctransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#chw2hwctransformer",children:"#"}),"CHW2HWCTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts NCHW to NHWC."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),": None."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# NCHW to NHWC"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"CHW2HWCTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"centercroptransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#centercroptransformer",children:"#"}),"CenterCropTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsxs)(s.p,{children:["Cuts out a square image from the center of the image by directly truncating the value. This transformer will convert the data format to ",(0,r.jsx)(s.code,{children:"float32"})," in the output.\nWhen the value of data_type is ",(0,r.jsx)(s.code,{children:"uint8"}),", the output is ",(0,r.jsx)(s.code,{children:"uint8"}),"."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"crop_size: Size of the sides of the square cropped from the center."}),"\n",(0,r.jsx)(s.li,{children:'data_type: Type of the output result. Value range: ["float", "uint8"].'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Performs center cropping with 224*224. Default output type: float32"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"CenterCropTransformer(crop_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=224) "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Performs center cropping with 224*224. Output type: uint8"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"CenterCropTransformer(crop_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=224, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"data_type="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"uint8"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"pilcentercroptransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#pilcentercroptransformer",children:"#"}),"PILCenterCropTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsxs)(s.p,{children:["Crops a square image from the center of the image by using the PIL method. This transformer will convert the data format to ",(0,r.jsx)(s.code,{children:"float32"})," in the output."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"size: Size of the sides of the square cropped from the center."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Performs center cropping with 224*224 by using the PIL method."})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PILCenterCropTransformer(size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=224)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"longsidecroptransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#longsidecroptransformer",children:"#"}),"LongSideCropTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Descriptions"}),":"]}),"\n",(0,r.jsxs)(s.p,{children:["Crops the longer side. This transformer will convert the data format to ",(0,r.jsx)(s.code,{children:"float32"})," in the output."]}),"\n",(0,r.jsxs)(s.p,{children:["When width > height, crops a square based on the height, e.g., suppose ",(0,r.jsx)(s.code,{children:"width=100"})," and ",(0,r.jsx)(s.code,{children:"height=70"}),", then the size after cropping is 70*70."]}),"\n",(0,r.jsxs)(s.p,{children:["When height > width, crops a rectangle whose width remains the same and height is ",(0,r.jsx)(s.code,{children:"(height-weight)/2 + width"}),", e.g., suppose ",(0,r.jsx)(s.code,{children:"width=70"})," and ",(0,r.jsx)(s.code,{children:"height=100"}),", the size after cropping is ",(0,r.jsx)(s.code,{children:"70*(100-70) /2+70"})," , which is a rectangle of size ",(0,r.jsx)(s.code,{children:"70*85"}),"."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),": None."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"LongSideCropTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"padresizetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#padresizetransformer",children:"#"}),"PadResizeTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsxs)(s.p,{children:["Enlarges the image by using the padding method. The transformer converts the data format to ",(0,r.jsx)(s.code,{children:"float32"})," in the output."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"target_size: Target size. The value is a tuple, e.g., (240,240)."}),"\n",(0,r.jsx)(s.li,{children:"pad_value: Value to be padded into the array, defaults to 127."}),"\n",(0,r.jsx)(s.li,{children:'pad_position: Padding position. Values range: ["boundary","bottom_right"], defaults to "boundary".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Crops a square of 512*512 pixels, padding to the bottom right corner, with a padding value of 0"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PadResizeTransformer((512,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"512"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"), pad_position="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'bottom_right'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:", pad_value=0)"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Crops a square of 608*608 pixels, padding to the border, with a padding value of 127"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PadResizeTransformer(target_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=(608, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"608"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"))"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"resizetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#resizetransformer",children:"#"}),"ResizeTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Resizes the image."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"target_size: Target size. The value is a tuple, e.g., (240,240): width=240, height=240."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:'mode: Image processing mode, takes a range of values ("skimage", "opencv"), defaults to "skimage".'}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"method: Interpolation method, this parameters only works in the skimage mode. Value range: [0,5], defaults to 1, of which :"}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"0: Nearest-neighbor;"}),"\n",(0,r.jsx)(s.li,{children:"1: Bi-linear(default);"}),"\n",(0,r.jsx)(s.li,{children:"2: Bi-quadratic;"}),"\n",(0,r.jsx)(s.li,{children:"3: Bi-cubic;"}),"\n",(0,r.jsx)(s.li,{children:"4: Bi-quartic;"}),"\n",(0,r.jsx)(s.li,{children:"5: Bi-quintic."}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:["data_type: Output type. Value range: (uint8, float), defaults to ",(0,r.jsx)(s.code,{children:"float"}),". When set to ",(0,r.jsx)(s.code,{children:"uint8"}),", the output type is ",(0,r.jsx)(s.code,{children:"uint8"}),", otherwise it is ",(0,r.jsx)(s.code,{children:"float32"}),"."]}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:["interpolation: Interpolation method. This parameter only takes effect when mode is ",(0,r.jsx)(s.code,{children:"opencv"}),". Value range: (opencv's interpolation method), defaults to ",(0,r.jsx)(s.code,{children:"null"}),". Currently, interpolation only supports empty, or two interpolation methods of ",(0,r.jsx)(s.code,{children:"INTER_CUBIC"})," in OpenCV, when it is empty, INTER_LINEAR method is used by default."]}),"\n",(0,r.jsx)(s.p,{children:"The following are the interpolation methods supported in OpenCV and their descriptions (interpolation methods not supported will be gradually added in subsequent iterations):"}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"INTER_NEAREST: Nearest Neighbor Interpolation."}),"\n",(0,r.jsx)(s.li,{children:"INTER_LINEAR: Bi-linear interpolation, used by default when the interpolation is empty."}),"\n",(0,r.jsx)(s.li,{children:"INTER_CUBIC: Bi-cubic interpolation within a 4x4 pixel neighborhood."}),"\n",(0,r.jsx)(s.li,{children:"INTER_AREA: Resampling using pixel area relation. It may be the preferred method for image decimation as it can provide moir\xe9-free results. But when the image is scaled, it is similar to the INTER_NEAREST method."}),"\n",(0,r.jsx)(s.li,{children:"INTER_LANCZOS4: Lanczos interpolation of 8x8 neighborhood."}),"\n",(0,r.jsx)(s.li,{children:"INTER_LINEAR_EXACT: Bit-accurate bilinear interpolation."}),"\n",(0,r.jsx)(s.li,{children:"INTER_NEAREST_EXACT: Bit-exact nearest neighbor interpolation. This will produce the same results as the nearest neighbor method in PIL, scikit-image, or Matlab."}),"\n",(0,r.jsx)(s.li,{children:"INTER_MAX: Mask for interpolation code."}),"\n",(0,r.jsx)(s.li,{children:"WARP_FILL_OUTLIERS: Flag, padding all target image pixels. If some of them correspond to outliers in the source image, set them to zero."}),"\n",(0,r.jsx)(s.li,{children:"WARP_INVERSE_MAP: Flag, inverter."}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Resizes the input image to 224*224, use OpenCV to process the image. Interpolation: bilinear, output: float32"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ResizeTransformer(target_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=(224, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"), mode="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'opencv'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:", method=1)"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Resizes the input image to 256*256, use skimage to process the image. Interpolation: bilinear, output: float32"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ResizeTransformer(target_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=(256, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"))"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Resizes input image to 256*256, use skimage to process the image. Interpolation: bilinear, output: uint8"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ResizeTransformer(target_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=(256, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"), data_type="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"uint8"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"pilresizetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#pilresizetransformer",children:"#"}),"PILResizeTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Resizes the image by using the PIL library."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"size: Target size. The value is a tuple, e.g., (240,240)."}),"\n",(0,r.jsxs)(s.li,{children:["interpolation: Specifies the interpolation method. Value range: (Image.NEAREST, Image.BILINEAR, Image.BICUBIC, Image.LANCZOS), default to ",(0,r.jsx)(s.code,{children:"Image.BILINEAR"}),".","\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"Image.NEAREST: Nearest neighbor sampling;"}),"\n",(0,r.jsx)(s.li,{children:"Image.BILINEAR: Linear interpolation;"}),"\n",(0,r.jsx)(s.li,{children:"Image.BICUBIC: Cubic spline interpolation;"}),"\n",(0,r.jsx)(s.li,{children:"Image.LANCZOS: High quality downsampling filter."}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Adjusts the input image size to 256*256 and the interpolation method is linear interpolation"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PILResizeTransformer(size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=256)"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Adjusts the input image size to to 256*256 and the interpolation method is a high-quality downsampling filter"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PILResizeTransformer(size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=256, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"interpolation=Image.LANCZOS"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"shortlongresizetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#shortlongresizetransformer",children:"#"}),"ShortLongResizeTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Scales the input image according to the original scale, and the size of the new image is related to the parameters set."}),"\n",(0,r.jsx)(s.p,{children:"Perform the operation as follows:"}),"\n",(0,r.jsxs)(s.ol,{children:["\n",(0,r.jsxs)(s.li,{children:["First, divide the size of ",(0,r.jsx)(s.code,{children:"short_size"})," by the smaller value of the width and height of the original image, and use this value as the scaling factor."]}),"\n",(0,r.jsxs)(s.li,{children:["When the scaling factor is multiplied by the larger value of the width and height of the original image and the result is greater than the value of ",(0,r.jsx)(s.code,{children:"long_size"}),", the scaling factor will be changed to ",(0,r.jsx)(s.code,{children:"long_size"})," divided by the larger value of the width and height of the original image."]}),"\n",(0,r.jsxs)(s.li,{children:["Use the ",(0,r.jsx)(s.code,{children:"resize"})," method in OpenCV to re-crop the image according to the scaling factor obtained above."]}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"short_size: Expected length of the short edge after cutting."}),"\n",(0,r.jsx)(s.li,{children:"long_size: Expected length of the short edge after cutting."}),"\n",(0,r.jsx)(s.li,{children:"include_im: Defaults to True. When set to True, it will return the original image in addition to the processed image."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Shorter edge length is 20, longer edge length is 100, returns both the processed image and the original image"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ShortLongResizeTransformer(short_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=20, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"long_size="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"100"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"padtransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#padtransformer",children:"#"}),"PadTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Resizes the image by dividing the target size by the larger value of the width or height of the input image, and then multiplying this factor by the original width and height."}),"\n",(0,r.jsxs)(s.p,{children:["Then according to the size of the new image, divide it by ",(0,r.jsx)(s.code,{children:"size_divisor"})," and round it up, then multiply it by ",(0,r.jsx)(s.code,{children:"size_divisor"})," to generate a new image with the new width and height."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"size_divisor: Size divisor, defaults to 128."}),"\n",(0,r.jsx)(s.li,{children:"target_size: Target size, defaults to 512."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# The pad size is 1024*1024"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PadTransformer(size_divisor"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=1024, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"target_size="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"shortsideresizetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#shortsideresizetransformer",children:"#"}),"ShortSideResizeTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"According to the desired length of the short side, this transformer use the current ratio of the long and short sides, and the crop out the operation of the new image size from the image center."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsx)(s.p,{children:"short_size: Expected length of short side."}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:['data_type: Type of the output result. Value range: ("float", "uint8"), defaults to "float32", output in ',(0,r.jsx)(s.code,{children:"float32"})," type, and when set to ",(0,r.jsx)(s.code,{children:"uint8"}),", the output type will be ",(0,r.jsx)(s.code,{children:"uint8"}),"."]}),"\n"]}),"\n",(0,r.jsxs)(s.li,{children:["\n",(0,r.jsxs)(s.p,{children:["interpolation: Interpolation method. Value range: (interpolation method used in OpenCV), defaults to empty.\nCurrently, interpolation only supports empty, or two interpolation methods of ",(0,r.jsx)(s.code,{children:"INTER_CUBIC"})," in OpenCV, when it is empty, INTER_LINEAR method is used by default."]}),"\n",(0,r.jsx)(s.p,{children:"The following are the interpolation methods supported in OpenCV and their descriptions (interpolation methods not supported will be gradually added in subsequent iterations)."}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"INTER_NEAREST: Nearest Neighbor Interpolation."}),"\n",(0,r.jsx)(s.li,{children:"INTER_LINEAR: Bi-linear interpolation, which is used by default when the interpolation is empty."}),"\n",(0,r.jsx)(s.li,{children:"INTER_CUBIC: Bi-cubic interpolation within a 4x4 pixel neighborhood."}),"\n",(0,r.jsx)(s.li,{children:"INTER_AREA: Resampling using pixel area relation. It may be the preferred method for image decimation as it can provide moir\xe9-free results. But when the image is scaled, it is similar to INTER_NEAREST method."}),"\n",(0,r.jsx)(s.li,{children:"INTER_LANCZOS4: Lanczos interpolation of 8x8 neighborhood."}),"\n",(0,r.jsx)(s.li,{children:"INTER_LINEAR_EXACT: Bit-accurate bilinear interpolation."}),"\n",(0,r.jsx)(s.li,{children:"INTER_NEAREST_EXACT: Bit-exact nearest neighbor interpolation. This will produce the same results as the nearest neighbor method in PIL, scikit-image, or Matlab."}),"\n",(0,r.jsx)(s.li,{children:"INTER_MAX: Mask for interpolation code."}),"\n",(0,r.jsx)(s.li,{children:"WARP_FILL_OUTLIERS: Flag, padding all target image pixels. If some of them correspond to outliers in the source image, set them to zero."}),"\n",(0,r.jsx)(s.li,{children:"WARP_INVERSE_MAP\uFF1B Flag, inverter."}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Adjusts the short side to 256 and the interpolation method is bilinear interpolation"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ShortSideResizeTransformer(short_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=256)"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Resize the short side to 256 and the interpolation method is Lanczos interpolation within the 8x8 pixel neighborhood"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ShortSideResizeTransformer(short_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=256, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"interpolation=Image.LANCZOS4"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"paddedcentercroptransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#paddedcentercroptransformer",children:"#"}),"PaddedCenterCropTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Crops the center of the image with padding."}),"\n",(0,r.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,r.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,r.jsxs)(s.div,{className:"rspress-directive-content",children:[(0,r.jsx)(s.p,{children:"Applicable only to EfficientNet-lite related instance models."}),(0,r.jsx)(s.p,{children:"Calculation method:"}),(0,r.jsxs)(s.ol,{children:["\n",(0,r.jsx)(s.li,{children:"Calculates the factor, int((float( image_size ) / ( image_size + crop_pad ))."}),"\n",(0,r.jsx)(s.li,{children:"Calculates the size of the center, coefficient * np.minimum(height of original image, width of original image))."}),"\n",(0,r.jsx)(s.li,{children:"Crops the image from its center according to the calculated size."}),"\n"]})]})]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"image_size: Size of the image, defaults to 224."}),"\n",(0,r.jsx)(s.li,{children:"crop_pad: Size of the center padding, defaults to 32."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Crop size is 240*240, padding value is 32"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PaddedCenterCropTransformer(image_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=240, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"crop_pad="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Crop size is 224*224, padding value is 32"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"PaddedCenterCropTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"bgr2rgbtransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#bgr2rgbtransformer",children:"#"}),"BGR2RGBTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from BGR to RGB."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"data_format: Data format. Value range: (CHW,HWC), defaults to CHW."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts BGR to RGB"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2RGBTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"# When the layout is NHWC,converts BGR to RGB"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"BGR2RGBTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"HWC"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"rgb2bgrtransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb2bgrtransformer",children:"#"}),"RGB2BGRTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from RGB to BGR."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"data_format: Data format.Value range: (CHW,HWC), defaults to CHW."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts RGB to BGR"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2BGRTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"# When the layout is NHWC, converts RGB to BGR"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"RGB2BGRTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"HWC"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"rgb2graytransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb2graytransformer",children:"#"}),"RGB2GRAYTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from RGB to GRAY."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ("CHW", "HWC"), defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts RGB to GRAY"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2GRAYTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts RGB to GRAY"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2GRAYTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"bgr2graytransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#bgr2graytransformer",children:"#"}),"BGR2GRAYTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from BGR to GRAY."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts BGR to GRAY"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2GRAYTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts BGR to GRAY"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2GRAYTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"rgb2gray_128transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb2gray_128transformer",children:"#"}),"RGB2GRAY_128Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from RGB to GRAY_128. Value range of GRAY_128: (-128,127)."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], required field, defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts RGB to GRAY_128"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2GRAY_128Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts RGB to GRAY_128"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2GRAY_128Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"rgb2yuv444transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb2yuv444transformer",children:"#"}),"RGB2YUV444Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from RGB to YUV444."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], required field, defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts RGB to YUV444"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2YUV444Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts RGB to YUV444"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2YUV444Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"bgr2yuv444transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#bgr2yuv444transformer",children:"#"}),"BGR2YUV444Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Convers the input format from BGR to YUV444."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], required field, defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts BGR to YUV444"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2YUV444Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts BGR to YUV444"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2YUV444Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"bgr2yuv444_128transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#bgr2yuv444_128transformer",children:"#"}),"BGR2YUV444_128Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from BGR to YUV444_128. Values range of YUV444_128: (-128,127)."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], required field, defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts BGR to YUV444_128"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2YUV444_128Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts BGR to YUV444_128"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2YUV444_128Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"rgb2yuv444_128transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb2yuv444_128transformer",children:"#"}),"RGB2YUV444_128Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from RGB to YUV444_128. Values range of YUV444_128: (-128,127)."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], required field, defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW , converts RGB to YUV444_128"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2YUV444_128Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts RGB to YUV444_128"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2YUV444_128Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"bgr2yuvbt601videotransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#bgr2yuvbt601videotransformer",children:"#"}),"BGR2YUVBT601VIDEOTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from BGR to YUV_BT601_Video_Range."}),"\n",(0,r.jsx)(s.p,{children:"YUV_BT601_Video_Range, some camera input data are YUV BT601 (Video Range) format. Value range: 16~235, this transformer is adapted to this format of data generated."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW","HWC"], required field, defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts BGR to YUV_BT601_Video_Range"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2YUVBT601VIDEOTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts BGR to YUV_BT601_Video_Range"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2YUVBT601VIDEOTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"rgb2yuvbt601videotransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb2yuvbt601videotransformer",children:"#"}),"RGB2YUVBT601VIDEOTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from RGB to YUV_BT601_Video_Range."}),"\n",(0,r.jsx)(s.p,{children:"YUV_BT601_Video_Range, some camera input data are YUV BT601 (Video Range) format. Value range: 16~235, this transformer is adapted to this format of data generated."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW","HWC"], required field, defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts RGB to YUV_BT601_Video_Range"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2YUVBT601VIDEOTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'CHW'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts RGB to YUV_BT601_Video_Range"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2YUVBT601VIDEOTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"'HWC'"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"yuvtransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#yuvtransformer",children:"#"}),"YUVTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format to YUV444."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"color_sequence: Color sequence, required field."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Converting BGR read-in images to YUV444"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"YUVTransformer(color_sequence"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:'"BGR"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Converting RGB read-in images to YUV444"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"YUVTransformer(color_sequence"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:'"RGB"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"reducechanneltransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#reducechanneltransformer",children:"#"}),"ReduceChannelTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Reduces the C channel to a single channel. The transformer is mainly for C channel, such as shape 1*3*224*224 to 1*1*224*224. In practice, the layout must be aligned with data_format value to avoid causing the wrong channel deletion."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], defaults to "CHW".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Delete the C channel with layout as NCHW"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ReduceChannelTransformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"# Or"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"ReduceChannelTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CHW"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Delete the C channel with layout as NHWC"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ReduceChannelTransformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:'"HWC"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"bgr2nv12transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#bgr2nv12transformer",children:"#"}),"BGR2NV12Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from BGR to NV12."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW","HWC"], defaults to "CHW".'}),"\n",(0,r.jsxs)(s.li,{children:["cvt_mode: cvt mode. Value range: (rgb_calc, OpenCV), defaults to rgb_calc.","\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"rgb_calc: Image processing using mergeUV."}),"\n",(0,r.jsx)(s.li,{children:"opencv: Image processing using OpenCV."}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts BGR to NV12, and the image is processed by rgb_calc"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2NV12Transformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"# Or"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"BGR2NV12Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CHW"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts BGR to NV12, and the image is processed by OpenCV"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"BGR2NV12Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:'"HWC"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"cvt_mode="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"opencv"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"rgb2nv12transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#rgb2nv12transformer",children:"#"}),"RGB2NV12Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from RGB to NV12."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:'data_format: Input layout type. Value range: ["CHW", "HWC"], defaults to "CHW".'}),"\n",(0,r.jsxs)(s.li,{children:["cvt_mode: cvt mode. Value range: (rgb_calc,opencv), defaults to rgb_calc.","\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"rgb_calc: Image processing using mergeUV."}),"\n",(0,r.jsx)(s.li,{children:"opencv: Image processing using opencv."}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NCHW, converts RGB to NV12, and the image is processed by rgb_calc"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2NV12Transformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"# Or"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"RGB2NV12Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CHW"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# When the layout is NHWC, converts RGB to NV12, and the image is processed by OpenCV"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2NV12Transformer(data_format"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:'"HWC"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:","}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"cvt_mode="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"opencv"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"nv12toyuv444transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#nv12toyuv444transformer",children:"#"}),"NV12ToYUV444Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from NV12 to YUV444."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"target_size: Target size. Value is a tuple, e.g., (240,240)."}),"\n",(0,r.jsx)(s.li,{children:'yuv444_output_layout: YUV444 output layout. Value range: (HWC,CHW), defaults to "HWC".'}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# layout is NCHW, size is 768*768, converts NV12 to YUV444"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"NV12ToYUV444Transformer(target_size"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"=(768, "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"768"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"))"})]}),"\n",(0,r.jsx)(s.span,{className:"line line-number"}),"\n",(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# layout is NHWC, size is 224*224, converts NV12 to YUV444 "})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"NV12ToYUV444Transformer((224,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"), yuv444_output_layout="}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"HWC"'}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:") "})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"warpaffinetransformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#warpaffinetransformer",children:"#"}),"WarpAffineTransformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Performs image affine transformations."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),":"]}),"\n",(0,r.jsxs)(s.ul,{children:["\n",(0,r.jsx)(s.li,{children:"input_shape: Input shape value."}),"\n",(0,r.jsx)(s.li,{children:"scale: Factor to be multiplied."}),"\n"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# The size is 512*512, the length of the long side is 1.0"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"WarpAffineTransformer((512,"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"512"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"), 1.0)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"f32tos8transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#f32tos8transformer",children:"#"}),"F32ToS8Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Convers the input format from float32 to int8."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),": None."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Conversion of input format from float32 to int8"})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"F32ToS8Transformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,r.jsxs)(s.h2,{id:"f32tou8transformer",children:[(0,r.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#f32tou8transformer",children:"#"}),"F32ToU8Transformer"]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Description"}),":"]}),"\n",(0,r.jsx)(s.p,{children:"Converts the input format from float32 to uint8."}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Parameters"}),": None."]}),"\n",(0,r.jsxs)(s.p,{children:[(0,r.jsx)(s.strong,{children:"Examples of use"}),":"]}),"\n",(0,r.jsx)(s.pre,{className:"code",children:(0,r.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(s.span,{className:"line line-number",children:(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Conversion of input format from float32 to uint8 "})}),"\n",(0,r.jsxs)(s.span,{className:"line line-number",children:[(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"F32ToU8Transformer"}),(0,r.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})})]})}function l(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:s}=Object.assign({},(0,i.ah)(),e.components);return s?(0,r.jsx)(s,Object.assign({},e,{children:(0,r.jsx)(a,e)})):a(e)}s.default=l,l.__RSPRESS_PAGE_META={},l.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fptq%2Fptq_appendix%2Ftransformer.mdx"]={toc:[{id:"addtransformer",text:"AddTransformer",depth:2},{id:"meantransformer",text:"MeanTransformer",depth:2},{id:"scaletransformer",text:"ScaleTransformer",depth:2},{id:"normalizetransformer",text:"NormalizeTransformer",depth:2},{id:"transposetransformer",text:"TransposeTransformer",depth:2},{id:"hwc2chwtransformer",text:"HWC2CHWTransformer",depth:2},{id:"chw2hwctransformer",text:"CHW2HWCTransformer",depth:2},{id:"centercroptransformer",text:"CenterCropTransformer",depth:2},{id:"pilcentercroptransformer",text:"PILCenterCropTransformer",depth:2},{id:"longsidecroptransformer",text:"LongSideCropTransformer",depth:2},{id:"padresizetransformer",text:"PadResizeTransformer",depth:2},{id:"resizetransformer",text:"ResizeTransformer",depth:2},{id:"pilresizetransformer",text:"PILResizeTransformer",depth:2},{id:"shortlongresizetransformer",text:"ShortLongResizeTransformer",depth:2},{id:"padtransformer",text:"PadTransformer",depth:2},{id:"shortsideresizetransformer",text:"ShortSideResizeTransformer",depth:2},{id:"paddedcentercroptransformer",text:"PaddedCenterCropTransformer",depth:2},{id:"bgr2rgbtransformer",text:"BGR2RGBTransformer",depth:2},{id:"rgb2bgrtransformer",text:"RGB2BGRTransformer",depth:2},{id:"rgb2graytransformer",text:"RGB2GRAYTransformer",depth:2},{id:"bgr2graytransformer",text:"BGR2GRAYTransformer",depth:2},{id:"rgb2gray_128transformer",text:"RGB2GRAY_128Transformer",depth:2},{id:"rgb2yuv444transformer",text:"RGB2YUV444Transformer",depth:2},{id:"bgr2yuv444transformer",text:"BGR2YUV444Transformer",depth:2},{id:"bgr2yuv444_128transformer",text:"BGR2YUV444_128Transformer",depth:2},{id:"rgb2yuv444_128transformer",text:"RGB2YUV444_128Transformer",depth:2},{id:"bgr2yuvbt601videotransformer",text:"BGR2YUVBT601VIDEOTransformer",depth:2},{id:"rgb2yuvbt601videotransformer",text:"RGB2YUVBT601VIDEOTransformer",depth:2},{id:"yuvtransformer",text:"YUVTransformer",depth:2},{id:"reducechanneltransformer",text:"ReduceChannelTransformer",depth:2},{id:"bgr2nv12transformer",text:"BGR2NV12Transformer",depth:2},{id:"rgb2nv12transformer",text:"RGB2NV12Transformer",depth:2},{id:"nv12toyuv444transformer",text:"NV12ToYUV444Transformer",depth:2},{id:"warpaffinetransformer",text:"WarpAffineTransformer",depth:2},{id:"f32tos8transformer",text:"F32ToS8Transformer",depth:2},{id:"f32tou8transformer",text:"F32ToU8Transformer",depth:2}],title:"Image Processing Transformer",frontmatter:{}}}}]);