"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["8120"],{31039:function(s,n,e){s.exports=e.p+"static/image/hbm_infer_pipeline_sample.125f0747.png"},24734:function(s,n,e){e.r(n);var i=e(85893),o=e(50065),l=e(31039);function r(s){let n=Object.assign({h1:"h1",a:"a",p:"p",ol:"ol",li:"li",h2:"h2",strong:"strong",code:"code",pre:"pre",span:"span",ul:"ul",table:"table",thead:"thead",tr:"tr",th:"th",tbody:"tbody",td:"td"},(0,o.ah)(),s.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(n.h1,{id:"transmission-optimization",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#transmission-optimization",children:"#"}),"Transmission Optimization"]}),"\n",(0,i.jsx)(n.p,{children:"Reducing the amount of input and output data transferred between the X86 side and the board side can improve the tool's performance. The tool can provide transmission optimization support for the following three usage scenarios."}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"The model input is fixed or updated periodically. If the input tensor of a multi-frame inference model remains unchanged, the input tensor does not need to be transmitted repeatedly; it only needs to be stored on the board side, and subsequent inferences can directly reuse the tensor on the board."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Model output filtering: Unused model outputs do not need to be transmitted back to the X86 side."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"In multi-model scenarios, the output of a preceding model can be directly used as the input for a subsequent model. In this case, the output tensor of the preceding model can be stored on the board side without being transmitted back, and the corresponding input for the subsequent model also does not need to be transmitted, as it can use the tensor stored on the board."}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.h2,{id:"classes-interfaces-and-parameters",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#classes-interfaces-and-parameters",children:"#"}),"Classes, Interfaces, and Parameters"]}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["Class ",(0,i.jsx)(n.strong,{children:"HTensor"})]}),"\n",(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.strong,{children:"HTensor"})," is used as the input and output tensor in transmission optimization scenarios. It is a wrapper class for tensors on the X86 side or the board side, designed to provide a unified data interface and restrict modifications to certain attributes to ensure data consistency."]}),"\n",(0,i.jsxs)(n.p,{children:["1). ",(0,i.jsx)(n.strong,{children:"HTensor"})," Member Method: ",(0,i.jsx)(n.code,{children:"__init__"})]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" Union"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"np"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"ndarray"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Tensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"device"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" Union"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"str"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" List"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"str"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"key"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"str"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:") "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"->"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:":"})]}),"\n"]})})}),"\n",(0,i.jsx)(n.p,{children:"Initialize an HTensor object."}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Parameters"}),"\n"]}),"\n",(0,i.jsxs)(n.table,{children:[(0,i.jsx)(n.thead,{children:(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.th,{children:(0,i.jsx)(n.strong,{children:"PARAMETER"})}),(0,i.jsx)(n.th,{children:(0,i.jsx)(n.strong,{children:"DESCRIPTIONS"})})]})}),(0,i.jsxs)(n.tbody,{children:[(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{children:(0,i.jsx)(n.code,{children:"data"})}),(0,i.jsxs)(n.td,{children:["Tensor data to be encapsulated. Supported types include ",(0,i.jsx)(n.code,{children:"numpy.ndarray"})," , ",(0,i.jsx)(n.code,{children:"torch.Tensor"})," , or ",(0,i.jsx)(n.code,{children:"None"})," ."]})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{children:(0,i.jsx)(n.code,{children:"device"})}),(0,i.jsxs)(n.td,{children:["Storage device of the tensor: ",(0,i.jsx)(n.code,{children:"None"})," (unavailable), ",(0,i.jsx)(n.code,{children:'"cpu"'})," (X86 side), ",(0,i.jsx)(n.code,{children:'"bpu"'})," (board side), or ",(0,i.jsx)(n.code,{children:'["cpu", "bpu"]'})," (both)."]})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{children:(0,i.jsx)(n.code,{children:"key"})}),(0,i.jsx)(n.td,{children:"A key value used on the board side to uniquely identify the tensor."})]})]})]}),"\n",(0,i.jsxs)(n.p,{children:["2). ",(0,i.jsx)(n.code,{children:"data"})," Attribute of ",(0,i.jsx)(n.strong,{children:"HTensor"})]}),"\n",(0,i.jsx)(n.p,{children:"Retrieves or assigns the tensor data. When assigning new data, if the existing data is not None, the data type must match that of the original."}),"\n",(0,i.jsxs)(n.p,{children:["3). ",(0,i.jsx)(n.code,{children:"device"})," Attribute of ",(0,i.jsx)(n.strong,{children:"HTensor"})]}),"\n",(0,i.jsx)(n.p,{children:"Obtains the storage device information of the tensor. This attribute is immutable once the object is constructed."}),"\n",(0,i.jsxs)(n.p,{children:["4). ",(0,i.jsx)(n.code,{children:"key"})," Attribute of ",(0,i.jsx)(n.strong,{children:"HTensor"})]}),"\n",(0,i.jsx)(n.p,{children:"Obtains the tensor\u2019s unique identification key on the server. This attribute is immutable once the object is constructed."}),"\n",(0,i.jsxs)(n.p,{children:["5). ",(0,i.jsx)(n.code,{children:"shape"})," Attribute of ",(0,i.jsx)(n.strong,{children:"HTensor"})]}),"\n",(0,i.jsx)(n.p,{children:"Obtains the shape of the tensor. Manual modifications are prohibited, as it is maintained automatically by the tool."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.code,{children:"output_config"})," Parameter of ",(0,i.jsx)(n.code,{children:"HbmRpcSession.__call__"})]}),"\n",(0,i.jsxs)(n.p,{children:["This parameter is used to configure the transmission behavior of the output tensor after the current inference frame ends. Its type is ",(0,i.jsx)(n.code,{children:"Dict[str, Dict[str, Any]]"})," , where the first-level keys are the model output names, and the second-level keys must include ",(0,i.jsx)(n.code,{children:'"device"'})," or ",(0,i.jsx)(n.code,{children:'"key"'})," (optional). The meanings and constraints of the values corresponding to ",(0,i.jsx)(n.code,{children:'"device"'})," or ",(0,i.jsx)(n.code,{children:'"key"'})," are consistent with the ",(0,i.jsx)(n.code,{children:"device"})," or ",(0,i.jsx)(n.code,{children:"key"})," parameters in the ",(0,i.jsx)(n.strong,{children:"HTensor"})," constructor."]}),"\n",(0,i.jsxs)(n.p,{children:["When a certain output name of the model is correctly configured in ",(0,i.jsx)(n.code,{children:"output_config"})," , the corresponding output tensor in the inference results returned for the current frame will be of type ",(0,i.jsx)(n.strong,{children:"HTensor"}),". Outputs that are not configured will be returned as regular types ( ",(0,i.jsx)(n.code,{children:"numpy.ndarray"})," or ",(0,i.jsx)(n.code,{children:"torch.Tensor"})," )."]}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.h2,{id:"examples-of-transmission-optimization-application",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#examples-of-transmission-optimization-application",children:"#"}),"Examples of Transmission Optimization Application"]}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Periodic Input Update"}),"\n",(0,i.jsxs)(n.p,{children:["In this example, it is assumed that the model has an input named ",(0,i.jsx)(n.code,{children:"img"})," , which is updated every ",(0,i.jsx)(n.code,{children:"10"})," frames during inference. On the first frame after the ",(0,i.jsx)(n.code,{children:"img"})," update, the tool will transfer it to the board side, while no input data will be transferred in the remaining frames."]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logging"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" hbm_infer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"hbm_rpc_session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HTensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logger"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"periodic_input_update"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"epoch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"50"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Create session"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(host"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"available_ip"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", local_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"local_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# img is updated periodically, so it needs to be wrapped using HTensor"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    fixed_img "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"HTensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Set initial data"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.int8),"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# For fixed input or periodically updated input scenarios,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# device can only be set to ["cpu", "bpu"]'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# "cpu" means the tensor is stored on the X86 side,'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# "bpu" means a copy of this tensor will be created and stored on the board side'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        device"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"bpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# Since "bpu" is included in device,'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# a key needs to be set to uniquely identify this tensor on the board side"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        key"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model.input_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Create model input dict"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"img"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" fixed_img"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" e "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(epoch):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"f"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Epoch: '}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"e"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Update img input when a certain condition is met"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" e "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"%"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# When HTensor.data is updated, the updated tensor data"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# will be transmitted to the board side in subsequent inference calls;"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# if not updated, no data transmission occurs"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            fixed_img"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"data "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.int8)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Inference"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        output "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" k"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" v "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" output"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"items"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"():"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(k, v.shape)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Close session"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"close_server"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"__main__"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    logger"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"setLevel"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(logging.DEBUG)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"periodic_input_update"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(epoch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"50"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n"]})})}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Output Filtering"}),"\n",(0,i.jsxs)(n.p,{children:["In this example, the model has three outputs: ",(0,i.jsx)(n.code,{children:"output_0"})," , ",(0,i.jsx)(n.code,{children:"output_1"})," , and ",(0,i.jsx)(n.code,{children:"output_2"})," . Among them, ",(0,i.jsx)(n.code,{children:"output_2"})," is unused and filtered out, so only ",(0,i.jsx)(n.code,{children:"output_0"})," and ",(0,i.jsx)(n.code,{children:"output_1"})," are returned to the X86 side."]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logging"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" hbm_infer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"hbm_rpc_session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HTensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logger"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"output_discard"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"():"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(host"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"available_ip"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", local_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"local_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Create input dict"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float32),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float32),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Configure output_config"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    output_config "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# output_0 is returned normally, so no configuration needed"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# output_1 is returned normally, so no configuration needed"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# output_2 is filtered out, i.e., it is not transmitted back to the X86 side"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# nor stored on the board side; set device to None."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# Since device does not include "bpu", key does not need to be set.'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"device"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Run inference on the model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    output "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", output_config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"output_config)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# In the inference results, output_0 and output_1 are returned normally as torch.Tensor;"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# output_2 is of type HTensor"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]))"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# <class 'torch.Tensor'>"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]))"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# <class 'torch.Tensor'>"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]))"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# <class 'hbm_infer.utils.HTensor'>"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Its data attribute is None, meaning data is not transmitted back"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"].data)"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# None"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Regardless of whether the output is discarded, its shape information is always returned"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"].shape)"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# (4, 1024, 1024)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"__main__"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    logger"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"setLevel"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(logging.DEBUG)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"output_discard"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Model Chaining"}),"\n",(0,i.jsxs)(n.p,{children:["This example assumes that the input HBM file contains two models: model0 and model1. The output of model0 named ",(0,i.jsx)(n.code,{children:"output_0"})," will be directly used as the input named ",(0,i.jsx)(n.code,{children:"input_0"})," for model1. In this process, the output of model0 does not need to be transmitted back to the X86 side, and the input of model1 does not need to be transmitted to the board side."]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logging"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" hbm_infer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"hbm_rpc_session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HTensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logger"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"model_chaining"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"():"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Create session"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(host"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"available_ip"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", local_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"local_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# [model0, model1]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Note: Model names are not equivalent to the HBM file names"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(session."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"get_model_names"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"())"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Create input dict for model0"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    model0_input "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float32)}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Configure output_config for model0"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    model0_output_config "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# output_0 does not need to be transmitted back and is stored directly on the board,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# so set device to "bpu" and assign a key'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"device"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"bpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"key"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model0.output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Run inference for model0"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    model0_output "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model0_input, output_config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model0_output_config, model_name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model0"'})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# model0.output_0 is of type HTensor"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model0_output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]))"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# <class 'hbm_infer.utils.HTensor'>"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Its data attribute is None, meaning data is not transmitted back"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model0_output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"].data)"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# None"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Regardless of whether the output tensor is transmitted back,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# its shape information is always returned"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model0_output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"].shape)"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# (4, 1024, 1024)"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Create input dict for model1"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    model1_input "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Directly use model0's output_0 inference result as model1's input_0."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# In subsequent inferences, model1's input_0 does not need to be transmitted,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# but reuses the tensor stored on the board based on the key value"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" model0_output"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Run inference for model1, its output is returned normally, no need to configure output_config"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    model1_output "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model1_input, model_name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model1_output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]))"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# <class 'torch.Tensor'>"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Close session"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"close_server"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"__main__"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    logger"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"setLevel"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(logging.DEBUG)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"model_chaining"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Comprehensive Application"}),"\n",(0,i.jsx)(n.p,{children:"The following inference pipeline covers the three scenarios of periodic input update, output filtering, and model chaining. The flowchart is as follows:"}),"\n",(0,i.jsx)("img",{src:l,alt:"hbm_infer_pipeline_sample",width:"600"}),"\n",(0,i.jsx)(n.p,{children:"The reference code is as follows:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logging"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" hbm_infer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"hbm_rpc_session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" HTensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" logger"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"test_pipeline"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-parameter)"},children:"epoch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"50"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Create session"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    session "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"HbmRpcSession"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(host"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"available_ip"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", local_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=<"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"pipeline_hbm_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# [model0, model1, model2]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Note: Model names are not equivalent to HBM file names"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"f"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Model list: '}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"session."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"get_model_names"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# model1's input_1 is updated periodically and needs to be wrapped with HTensor"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    model1_fixed_input1 "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"HTensor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Set initial data"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float32) "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# For fixed or periodically updated input scenarios,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# device can only be set to ["cpu", "bpu"]'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# "cpu" means the tensor is stored on the X86 side,'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# "bpu" means a copy of this tensor will be created and stored on the board side'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        device"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"bpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:'# Since device includes "bpu",'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# a key must be set to uniquely identify this tensor on the board side"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        key"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model1.input_1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" e "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(epoch):"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"f"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Epoch: '}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"e"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# model0's input_0 is a normal input"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model0_input "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float32)"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Save model0's output_0 on the board side, and the actual tensor data"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# is not transmitted back to the X86 side. The inference result is returned"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# as an HTensor and can be directly used as input for subsequent models."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The data attribute of this HTensor will be None, but you can still get"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# its shape attribute. When used as input for subsequent models, the tool"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# will automatically locate the corresponding tensor on the board by its key."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model0_output_config "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"device"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"bpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"key"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model0.output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Inference for model0"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model0_output "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model0_input,"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Set output_config"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            output_config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model0_output_config,"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Specify the model name for inference"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            model_name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Simulate periodic update of model1's input_1"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" e "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"%"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            model1_fixed_input1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"data "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                torch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ones"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), dtype"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float32)"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model1_input "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Directly use model0's output_0 as model1's input_0"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" model0_output"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Fixed input1"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" model1_fixed_input1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model1_output_config "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Discard output_0 by setting device to None"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"device"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"},"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# output_1 is returned normally, so no need to configure in output_config"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Store output_2 on the board side and simultaneously transmit it back to the X86 side"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"device"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"bpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"key"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model1.output2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"},"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Inference for model1"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model1_output "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model1_input,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            output_config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model1_output_config,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            model_name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        )"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Use model1's output_2 as model2's input_0"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model2_input "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_0"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" model1_output"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Inference for model2"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        model2_output "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model2_input, model_name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"model2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Check the result"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"print"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"f"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"all"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model2_output["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'output_0'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"] "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Close session"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    session"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"close_server"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"__main__"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    logger"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"setLevel"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(logging.DEBUG)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"test_pipeline"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(epoch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"100"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n"]})})}),"\n"]}),"\n"]})]})}function t(){let s=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,o.ah)(),s.components);return n?(0,i.jsx)(n,Object.assign({},s,{children:(0,i.jsx)(r,s)})):r(s)}n.default=t,t.__RSPRESS_PAGE_META={},t.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fucp%2Fruntime%2Ftool_introduction%2Fhbm_infer%2Ftrans_optimization.mdx"]={toc:[{id:"classes-interfaces-and-parameters",text:"Classes, Interfaces, and Parameters",depth:2},{id:"examples-of-transmission-optimization-application",text:"Examples of Transmission Optimization Application",depth:2}],title:"Transmission Optimization",frontmatter:{}}}}]);