"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["8224"],{23776:function(e,n,s){s.r(n);var i=s(85893),r=s(50065);function t(e){let n=Object.assign({h1:"h1",a:"a",p:"p",ul:"ul",li:"li",div:"div",h2:"h2",code:"code",h3:"h3",strong:"strong",pre:"pre",span:"span"},(0,r.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(n.h1,{id:"the-quant_config-introduction",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#the-quant_config-introduction",children:"#"}),"The quant_config Introduction"]}),"\n",(0,i.jsx)(n.p,{children:"When converting a model, you can use quant_config to configure the model's quantization parameters from multiple levels: model_config, op_config, subgraph_config and node_config:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"model_config: Configure the overall quantization parameters for the model, key is a custom name."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"op_config: Configure the quantization parameters for nodes with a certain type, key is the operator type."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"subgraph_config: Configure the quantization parameters for a subgraph, key is the subgraph name."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"node_config: Configure the quantization parameters for a specific node, key is the name of the node."}),"\n"]}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"There is a priority relationship between the four levels, the smaller the configuration granularity, the higher the priority, i.e., priority model_config < op_config < subgraph_config < node_config.\nWhen a node is configured by more than one level at the same time, the level with the highest priority takes effect in the end."}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive info",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsx)(n.p,{children:"Since the model quantization and compilation process internally will split and fuse some operators, it may cause some split operators' names to not be exactly the same as those of the original model operators.\nFor such operators, when specifying the node_config, the operator names should refer to the corresponding operator names in the optimized_float_model.onnx model generated during the process."})})]}),"\n",(0,i.jsxs)(n.h2,{id:"configure-computation-accuracy",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configure-computation-accuracy",children:"#"}),"Configure computation accuracy"]}),"\n",(0,i.jsxs)(n.p,{children:["The quant_config supports the configuration of ",(0,i.jsx)(n.code,{children:"int8/int16/float16"})," three kinds of computation accuracy data types, about these three kinds of data types are described as follows:"]}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"int8: The default quantization type for most operators, which generally does not need to be actively configured by you."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["int16: You can refer to the section ",(0,i.jsx)(n.a,{href:"#int16_config",children:"int16 Configuration"}),"."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"float16: When configured as the float16 type, the tool will internally only configure this operator as the float16 computation accuracy type."}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,i.jsx)(n.p,{children:"For the float16 datatype:"}),(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"There will be no computation broadcast updates to the float16 computation operator context operators."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["Different computing platforms have different support scopes for float16 operators.\nFor the specific support scope, please refer to the ",(0,i.jsx)(n.a,{href:"/latest/en/guide/appendix/supported_op_list.html",children:"Toolchain Operator Support Contraint List"}),"."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"If you configure an operator that doesn't support float16 type to conduct float16 calculation, we will revert it to the float32 type for calculation."}),"\n"]}),"\n"]})]})]}),"\n",(0,i.jsxs)(n.h3,{id:"configure-the-computation-accuracy-for-the-entire-model",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configure-the-computation-accuracy-for-the-entire-model",children:"#"}),"Configure the computation accuracy for the entire model"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"17%"}}),(0,i.jsx)("col",{style:{width:"19%"}}),(0,i.jsx)("col",{style:{width:"17%"}}),(0,i.jsx)("col",{style:{width:"17%"}}),(0,i.jsx)("col",{style:{width:"30%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{rowSpan:"2",children:"model_config"}),(0,i.jsx)("td",{children:"all_node_type"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Set the inputs of all nodes in the model to the specified type at once, with optional configuration of int16,float16."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"model_output_type"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Set the output tensor of the model to the specified type, with optional configuration of int8,int16."})]})]})]}),"\n",(0,i.jsxs)(n.h3,{id:"configure-the-computation-accuracy-for-nodes-with-certain-type",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configure-the-computation-accuracy-for-nodes-with-certain-type",children:"#"}),"Configure the computation accuracy for nodes with certain type"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"20%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsx)("tbody",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"op_config"}),(0,i.jsx)("td",{children:"NodeKind"}),(0,i.jsx)("td",{children:"qtype"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Configure the input data type of a node of a certain type, with optional configuration of int8,int16,float16,float32."})]})})]}),"\n",(0,i.jsxs)(n.h3,{id:"configure-the-computation-accuracy-for-a-subgraph",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configure-the-computation-accuracy-for-a-subgraph",children:"#"}),"Configure the computation accuracy for a subgraph"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"20%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{rowSpan:"3",children:"subgraph_config"}),(0,i.jsx)("td",{rowSpan:"3",children:"SubgraphName"}),(0,i.jsx)("td",{children:"inputs"}),(0,i.jsx)("td",{children:"List"}),(0,i.jsx)("td",{children:"Required"}),(0,i.jsx)("td",{children:"Configure input node names for enclosed subgraphs. Extraction operations abort when encountering unenclosed subgraphs due to missing input nodes."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"outputs"}),(0,i.jsx)("td",{children:"List"}),(0,i.jsx)("td",{children:"Required"}),(0,i.jsx)("td",{children:"Configure output node names for enclosed subgraphs."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"qtype"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Configure the input data type for all nodes within the subgraph, with optional configuration of int8,int16,float16,float32."})]})]})]}),"\n",(0,i.jsxs)(n.h3,{id:"configure-the-computation-accuracy-for-a-specific-node",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configure-the-computation-accuracy-for-a-specific-node",children:"#"}),"Configure the computation accuracy for a specific node"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"20%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{rowSpan:"3",children:"node_config"}),(0,i.jsx)("td",{rowSpan:"3",children:"NodeName"}),(0,i.jsx)("td",{children:"qtype"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Configure the input data type of a node with a specified name, with optional configuration of int8,int16,float16,float32."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"input0"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Configure the 0th input data type of a node with a specified name, with optional configuration of int8,int16,float16,float32,ec."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"input1"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Configure the 1st input data type of a node with a specified name, with optional configuration of int8,int16,float16,float32,ec."})]})]})]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,i.jsx)(n.p,{children:"The input data type of a node can be specified by qtype, input0, or input1. qtype is generally used to specify the data type for all inputs of a node. input0 and input1 are used to specify the data type for the 0th and 1st inputs of a node, respectively. Moreover, the priority of input0 and input1 is higher than that of qtype."}),(0,i.jsx)(n.p,{children:"ec stands for error compensate. It is a solution that compensates for the precision loss of int8 quantization for specific operators by creating the same operator. Currently, it only supports the following operators, and configuring other operators will not take effect."}),(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"The weight input of Conv and ConvTranspose operators (specified through the third-level parameter input1 in node_config)."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Any input of MatMul operator (specified through the third-level parameter input0 or input1 in node_config)."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"The 0th input of GridSample and Resize operators (specified through the third-level parameter input0 in node_config)."}),"\n"]}),"\n"]})]})]}),"\n",(0,i.jsxs)(n.h2,{id:"configuring-calibration-parameters",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configuring-calibration-parameters",children:"#"}),"Configuring calibration parameters"]}),"\n",(0,i.jsx)(n.p,{children:"The quant_config supports configuring multiple calibration algorithms such as kl, max, etc. For each calibration algorithm, you can also flexibly control the specific hyperparameter configuration(if not configured, default value will be used). In addition, some independent calibration functions such as per_channel, asymmetric, bias_correction can also be configured."}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsx)(n.p,{children:"If quant_config is not configured, multiple pre-set calibration algorithms will be tried by default, and the calibration algorithm with minimum quantization loss will be selected."})})]}),"\n",(0,i.jsxs)(n.h3,{id:"configuring-calibration-parameters-for-activation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configuring-calibration-parameters-for-activation",children:"#"}),"Configuring calibration parameters for activation"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"20%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{rowSpan:"6",children:"model_config"}),(0,i.jsx)("td",{rowSpan:"6",children:"activation"}),(0,i.jsx)("td",{children:"calibration_type"}),(0,i.jsx)("td",{children:"String/List[String]"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Calibration algorithms for activation, with optional configuration of kl, max. It supports configuring a List with multiple calibration algorithms."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"num_bin"}),(0,i.jsx)("td",{children:"Int/List[Int]"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Parameter of kl calibration algorithm, requires num_bin > 128, and the default value is 1024. It supports configuring a List with multiple num_bin values."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"max_num_bin"}),(0,i.jsx)("td",{children:"Int"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Parameter of kl calibration algorithm, requires max_num_bin >= num_bin, and the default value is 16384."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"max_percentile"}),(0,i.jsx)("td",{children:"Float/List[Float]"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Parameter of max calibration algorithm, with parameter range in [0.5, 1.0], and the default value is 1.0. It supports configuring a List with multiple max_percentile values."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"per_channel"}),(0,i.jsx)("td",{children:"Bool/List[Bool]"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Whether per-channel quantization is enabled or not, with optional configuration of false, true, and the default value is false. It supports configuring a List that includes both per-channel enabled and disabled."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"asymmetric"}),(0,i.jsx)("td",{children:"Bool/List[Bool]"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Whether asymmetric quantization is enabled or not, with optional configuration of false, true, and the default value is false. It supports configuring a List that includes both asymmetric enabled and disabled."})]})]})]}),"\n",(0,i.jsxs)(n.h3,{id:"configuring-calibration-parameters-for-weight",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configuring-calibration-parameters-for-weight",children:"#"}),"Configuring calibration parameters for weight"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"10%"}}),(0,i.jsx)("col",{style:{width:"10%"}}),(0,i.jsx)("col",{style:{width:"10%"}}),(0,i.jsx)("col",{style:{width:"10%"}}),(0,i.jsx)("col",{style:{width:"10%"}}),(0,i.jsx)("col",{style:{width:"30%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Quaternary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{rowSpan:"2",children:"model_config"}),(0,i.jsx)("td",{rowSpan:"2",children:"weight"}),(0,i.jsx)("td",{rowSpan:"2",children:"bias_correction"}),(0,i.jsx)("td",{children:"num_sample"}),(0,i.jsx)("td",{children:"Int"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"The number of samples for bias correction, requires num_sample >= 1, and the default vaue is 1."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"metric"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"The model error metric for bias correction, with optional configuration of cosine-similarity, mse, mae, mre, sqnr and chebyshev, and the default value is cosine-similarity."})]})]})]}),"\n",(0,i.jsxs)(n.h2,{id:"configuring-search-methods-for-calibration-parameters",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configuring-search-methods-for-calibration-parameters",children:"#"}),"Configuring search methods for calibration parameters"]}),"\n",(0,i.jsx)(n.p,{children:"The quant_config supports two search methods with different granularities:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"modelwise_search: Search for quantization parameters at model level. This method allows multiple calibration algorithms to be configured at one time. By comparing the quantization loss with metric configured by you based on the model output before and after quantization, a calibration algorithm with the minimum quantization loss is selected."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"layerwise_search: Search for quantization parameters at node level. This method calculates the quantization loss with metric configured by you based on the model output before and after the quantization of each node, and assigns the calibration algorithm with the minimum quantization loss to the node."}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsx)(n.p,{children:"If multiple calibration algorithms are configured, modelwise search will be enabled by default to find the optimal algorithm for current model; if the layerwise search parameters are configured, a layer by layer search for the optimal algorithm will be initiated."})})]}),"\n",(0,i.jsxs)(n.h3,{id:"configuring-the-modelwise-search-method",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configuring-the-modelwise-search-method",children:"#"}),"Configuring the modelwise search method"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"20%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsx)("tbody",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"model_config"}),(0,i.jsx)("td",{children:"modelwise_search"}),(0,i.jsx)("td",{children:"metric"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"The model error metric for modelwise search, with optional configuration of cosine-similarity, mse, mae, mre, sqnr and chebyshev, and the default value is cosine-similarity."})]})})]}),"\n",(0,i.jsxs)(n.h3,{id:"configuring-the-layerwise-search-method",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configuring-the-layerwise-search-method",children:"#"}),"Configuring the layerwise search method"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"20%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Parameter Type"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsx)("tbody",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{rowSpan:"3",children:"model_config"}),(0,i.jsx)("td",{rowSpan:"3",children:"layerwise_search"}),(0,i.jsx)("td",{children:"metric"}),(0,i.jsx)("td",{children:"String"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"The model error metric for layerwise search, with optional configuration of cosine-similarity, mse, mae, mre, sqnr and chebyshev, and the default value is cosine-similarity."})]})})]}),"\n",(0,i.jsxs)(n.h2,{id:"configuration-example-of-the-json-template",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#configuration-example-of-the-json-template",children:"#"}),"Configuration example of the json template"]}),"\n",(0,i.jsx)(n.p,{children:"The following is an example of a json template configuration of the quant_config with all the configurable options, you can refer to this template for configuration."}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-json",meta:"",children:[(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure model-level parameters"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"model_config"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure input data types for all nodes at once"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"all_node_type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the data type of the model output"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"model_output_type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure calibration parameters for activation"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"activation"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure calibration algorithm for activation, with parameter type: String or List[String]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"calibration_type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"max"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"kl"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"max"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"kl"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the parameter for kl calibration algorithm, with parameter type: Int or List[Int]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"num_bin"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2048"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"2048"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the parameter for kl calibration algorithm, with parameter type: Int"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"max_num_bin"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"16384"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the parameter for max calibration algorithm, with parameter type: Float or List[Float]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"max_percentile"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.99995"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.99995"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure whether per-channel quantization is enabled or not, with parameter type: Bool or List[Bool]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"per_channel"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"true"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"false"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"true"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"false"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure whether asymmetric quantization is enabled or not, with parameter type: Bool or List[Bool]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"asymmetric"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"true"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"false"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"true"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"false"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure calibration parameters for weight"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"weight"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure bias correction"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"bias_correction"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                 "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the number of samples for bias correction, with parameter type: Int"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                 "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"num_sample"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                 "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the model error metric for bias correction, with parameter type: String"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"                 "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"metric"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cosine-similarity"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mse"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mae"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mre"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"sqnr"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"chebyshev"'})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             }"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure modelwise search, if multiple calibration algorithms are configured, modelwise search will be enabled to select the best one with minimum quantization loss"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"modelwise_search"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the model error metric for modelwise search, with parameter type: String"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"metric"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cosine-similarity"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mse"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mae"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mre"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"sqnr"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"chebyshev"'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure layerwise search, if layerwise search parameters are configured, a layer by layer search for the optimal algorithm will be initiated"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"layerwise_search"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the model error metric for layerwise search, with parameter type: String"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"             "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"metric"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cosine-similarity"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mse"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mae"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mre"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"sqnr"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"chebyshev"'})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"         }"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the parameters of a node type, change the op_name to the node type name, e.g. \u201CConv\u201D, \u201CAdd\u201D, \u201CSoftmax\u201D..."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"op_config"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the type of input data for a certain type of node"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"op_name1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"qtype"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"op_name2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"qtype"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure parameters for a subgraph, change the subgraph_name to your custom subgraph name, "})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// and update input_node/output_node with the actual input/output node names of the subgraph. e.g. \u201CConv_0\u201D, \u201CAdd_1\u201D..."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"subgraph_config"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the input data type for all nodes within the subgraph"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"subgraph_name1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"inputs"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_node1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input_node2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"outputs"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output_node1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"]"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"qtype"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float16"'})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        }"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the parameters of a node, change the node_name to the name of the node, e.g. \u201CConv_0\u201D, \u201CAdd_1\u201D..."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"node_config"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the input data type of a node"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"node_name1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"qtype"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"node_name2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"qtype"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    }"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.h2,{id:"int16_config",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#int16_config",children:"#"}),"int16 Configuration"]}),"\n",(0,i.jsxs)(n.p,{children:["In the process of model conversion, most of the operators in the model are quantized to int8 for computation, and by configuring the ",(0,i.jsx)(n.code,{children:"quant_config"})," parameter.\nYou can specify in detail the input or the output of an op as int16 calculation (The range of operators supporting the configuration of int16 you can refer to ",(0,i.jsx)(n.a,{href:"/latest/en/guide/appendix/supported_op_list.html",children:"Toolchain Operator Support Constraint List"}),") The basic principle is as follows:basically as follows."]}),"\n",(0,i.jsx)(n.p,{children:"After you configure an op input/output data type to int16, the model conversion automatically performs an update and check of the op input/output context int16 configuration internally.\nFor example, when configuring op_1 input/output data type as int16, it actually potentially specifies that the previous/next op of op_1 needs to support computation in int16 at the same time. For unsupported scenarios,\nthe model conversion tool will print a log indicating that the int16 configuration combination is temporarily unsupported and fall back to int8 computation."})]})}function o(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,r.ah)(),e.components);return n?(0,i.jsx)(n,Object.assign({},e,{children:(0,i.jsx)(t,e)})):t(e)}n.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fptq%2Fptq_tool%2Fhb_compile%2Fquant_config.mdx"]={toc:[{id:"configure-computation-accuracy",text:"Configure computation accuracy",depth:2},{id:"configure-the-computation-accuracy-for-the-entire-model",text:"Configure the computation accuracy for the entire model",depth:3},{id:"configure-the-computation-accuracy-for-nodes-with-certain-type",text:"Configure the computation accuracy for nodes with certain type",depth:3},{id:"configure-the-computation-accuracy-for-a-subgraph",text:"Configure the computation accuracy for a subgraph",depth:3},{id:"configure-the-computation-accuracy-for-a-specific-node",text:"Configure the computation accuracy for a specific node",depth:3},{id:"configuring-calibration-parameters",text:"Configuring calibration parameters",depth:2},{id:"configuring-calibration-parameters-for-activation",text:"Configuring calibration parameters for activation",depth:3},{id:"configuring-calibration-parameters-for-weight",text:"Configuring calibration parameters for weight",depth:3},{id:"configuring-search-methods-for-calibration-parameters",text:"Configuring search methods for calibration parameters",depth:2},{id:"configuring-the-modelwise-search-method",text:"Configuring the modelwise search method",depth:3},{id:"configuring-the-layerwise-search-method",text:"Configuring the layerwise search method",depth:3},{id:"configuration-example-of-the-json-template",text:"Configuration example of the json template",depth:2},{id:"int16_config",text:"int16 Configuration",depth:2}],title:"The quant_config Introduction",frontmatter:{}}}}]);