"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["8662"],{30366:function(s,e,n){n.r(e);var r=n(85893),l=n(50065);function i(s){let e=Object.assign({h1:"h1",a:"a",p:"p",h2:"h2",pre:"pre",code:"code",span:"span",ol:"ol",li:"li",h3:"h3",div:"div",h4:"h4",ul:"ul"},(0,l.ah)(),s.components);return(0,r.jsxs)(r.Fragment,{children:[(0,r.jsxs)(e.h1,{id:"the-practical-guide-to-deploying-resnet18-model-with-dequantize-nodes-removed",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#the-practical-guide-to-deploying-resnet18-model-with-dequantize-nodes-removed",children:"#"}),"The Practical Guide to Deploying ResNet18 Model with Dequantize Nodes Removed"]}),"\n",(0,r.jsx)(e.p,{children:"The overall process of using the PTQ pipeline of the Horizon OpenExplorer toolchain includes multiple phases such as model optimization,\nmodel calibration, model conversion to fixed-point model, model compilation and boarding.\nThis section takes the removing dequantize node from the RGB input classification model based on the public version of ResNet18 as a sample(S100 Platform),\nand the step-by-step deployment practice is demonstrated in use for your reference."}),"\n",(0,r.jsxs)(e.h2,{id:"prepare-the-floating-point-model",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#prepare-the-floating-point-model",children:"#"}),"Prepare the Floating Point Model"]}),"\n",(0,r.jsx)(e.p,{children:"To prepare the ResNet18 floating point model, here we use torchvision to export the desired floating point model."}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:'title="prepare_model.py"',children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torchvision"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torchvision"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"models"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resnet18"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(pretrained"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"input_shape "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"input_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"randn"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(input_shape)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"output_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"resnet18.onnx"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"torch"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"onnx"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"export"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model, input_data, output_path,"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  input_names"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"], output_names"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"output"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  opset_version"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.h2,{id:"calibration-set-preparation",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#calibration-set-preparation",children:"#"}),"Calibration Set Preparation"]}),"\n",(0,r.jsxs)(e.p,{children:["Information about the public version of the ResNet18 model can be found in ",(0,r.jsx)(e.a,{href:"https://pytorch.org/vision/main/models/generated/torchvision.models.resnet18.html",target:"_blank",rel:"noopener noreferrer",children:"The ResNet18 description within the Pytorch documentation"}),",\nwhere it can be seen that the data preprocessing flow for the ResNet18 model is:"]}),"\n",(0,r.jsxs)(e.ol,{children:["\n",(0,r.jsx)(e.li,{children:"The image short side deflates to 256."}),"\n",(0,r.jsx)(e.li,{children:"Resize the image to 224x224 with center crop."}),"\n",(0,r.jsx)(e.li,{children:"The data were normalized with mean taking the values [0.485, 0.456, 0.406] and std taking the values [0.229, 0.224, 0.225]."}),"\n"]}),"\n",(0,r.jsx)(e.p,{children:"A sample data preprocessing code is shown below:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:'title="data_preprocess.py"',children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cv2"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" PIL"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" PIL "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Image"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ori_dataset_dir "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./calibration_data/imagenet"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"calibration_dir "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./calibration_data_rgb"'})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize_transformer"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"image_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"array"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"short_size"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"fromarray"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_data."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'uint8'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'RGB'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Specify width, height"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    w"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"size  "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"and"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" short_size) "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"or"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"and"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" short_size)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# I.e., the width of the image is the short side"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" h"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        resize_size "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (short_size"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(short_size "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" h "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" w)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# I.e., the height of the image is the short side"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"else"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        resize_size "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(short_size "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" w "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" h),"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" short_size)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Resize the image"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(resize_size, Image.BILINEAR))"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" data"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"center_crop_transformer"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"image_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"array"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"crop_size"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"fromarray"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_data."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'uint8'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'RGB'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_width"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"size"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    crop_height"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" crop_width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (crop_size"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" crop_size)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    crop_top "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"round"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((image_height "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" crop_height) "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:".))"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    crop_left "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"round"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((image_width "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" crop_width) "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:".))"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"crop"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"((crop_left,"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                             crop_top,"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                             crop_left "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" crop_width,"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                             crop_top "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" crop_height))"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_data)."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.float32)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"mkdir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(calibration_dir)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_name "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"listdir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(ori_dataset_dir):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(ori_dataset_dir, image_name)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# load the image with PIL method"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    pil_image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" PIL"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Image"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"open"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_path)."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"convert"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'RGB'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(pil_image_data)."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Resize the image"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize_transformer"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_data, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Crop the image"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"center_crop_transformer"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_data, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Adjust the data range from [0, 255] to [0, 1]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"255"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Normalization, (data - mean) / std"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    mean "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.485"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.456"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.406"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" mean"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    std "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.229"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.224"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.225"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Convert format from HWC to CHW"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"transpose"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image_data, ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.float32)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Convert format from CHW to NCHW"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    image_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" image_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"newaxis"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":]"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Save the npy file"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    cali_file_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(calibration_dir, image_name[:"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"] "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'".npy"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"save"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(cali_file_path, image_data)"})]}),"\n"]})})}),"\n",(0,r.jsx)(e.p,{children:"To support PTQ model calibration, we need to take a small batch dataset from the ImageNet dataset, using the first 100 images as a sample here:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"./imagenet"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000001.JPEG"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000002.JPEG"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000003.JPEG"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ......"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000099.JPEG"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 ILSVRC2012_val_00000100.JPEG"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsx)(e.p,{children:"The catalog structure of the calibration set generated based on the data preprocessing code above is then as follows:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"./calibration_data_rgb"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000001.npy"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000002.npy"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000003.npy"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ......"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ILSVRC2012_val_00000099.npy"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 ILSVRC2012_val_00000100.npy"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsxs)(e.h2,{id:"board_model",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#board_model",children:"#"}),"Generate Board-side Model"]}),"\n",(0,r.jsx)(e.p,{children:"PTQ Conversion Link supports both command line tools and PTQ API for model quantization compilation to generate board-side models,\nthe following is an introduction to the use of the two ways."}),"\n",(0,r.jsxs)(e.h3,{id:"command-line-tool",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#command-line-tool",children:"#"}),"Command-line Tool"]}),"\n",(0,r.jsx)(e.p,{children:"The command line tool approach only requires you to install horizon_tc_ui(pre-installed in the Docker environment) and create the corresponding yaml file based on the model information configuration,\nhere we take the yaml file corresponding to the ResNet18 model with Dequantize nodes removed(config.yaml) to show and explain."}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-yaml",meta:'title="config.yaml"',children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"model_parameters"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"onnx_model"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'resnet18.onnx'"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"march"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"nash-e"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"working_dir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'model_output'"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"output_model_file_prefix"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'resnet18_224x224_rgb_removed'"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"remove_node_type"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'Dequantize'"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_parameters"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_name"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"''"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_shape"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"''"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_type_rt"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'featuremap'"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_type_train"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'featuremap'"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"calibration_parameters"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"cal_data_dir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'./calibration_data_rgb'"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"compiler_parameters"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"optimize_level"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'O2'"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.div,{className:"rspress-directive tip",children:[(0,r.jsx)(e.div,{className:"rspress-directive-title",children:"Note"}),(0,r.jsx)(e.div,{className:"rspress-directive-content",children:(0,r.jsxs)(e.p,{children:["Here, ",(0,r.jsx)(e.code,{children:"input_name"})," and ",(0,r.jsx)(e.code,{children:"input_shape"})," are left empty because the tool supports the scenario of single input with no dynamic shape (i.e., the tool internally parses the ONNX model and obtains the name and shape of the input)."]})})]}),"\n",(0,r.jsxs)(e.p,{children:["When the yaml file configuration is complete, you just need to call ",(0,r.jsx)(e.a,{href:"/latest/en/guide/ptq/ptq_tool/hb_compile/convert.html",children:"The hb_compile Tool"})," to execute the command, the tool executes the command and the key log is as follows:"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"[horizon@xxx xxx]$ hb_compile -c config.yaml"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"Start"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"hb_compile..."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Start"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"verifying"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"yaml"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"End"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"verifying"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"yaml"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Start"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Horizon"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"NN"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Model"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Convert."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Start"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"prepare"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"onnx"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"End"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"prepare"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"onnx"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Start"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"optimize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"onnx"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"End"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"optimize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"onnx"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Start"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"calibrate"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"End"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"calibrate"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Start"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"precompile"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"End"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"precompile"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"the"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"End"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"to"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Horizon"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"NN"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Model"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Convert."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"Successful"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"covert"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model."})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=================================================="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]100%"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"############# Model input/output info #############"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"NAME"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"   "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"TYPE"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"   "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"SHAPE"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"DATA_TYPE"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"------"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"------"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"----------------"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"---------"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  [1, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"FLOAT32"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" [1, "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1000"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"]"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"INT32"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"INFO"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"The"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"hb_compile"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"completes"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"running"})]}),"\n"]})})}),"\n",(0,r.jsx)(e.p,{children:"After the completion of the command execution, in the yaml file working_dir parameter configuration of the directory (model_output),\nwill be generated as shown below each stage of the intermediate model, the final model on the board and the model information file,\nof which resnet18_224x224_rgb_removed.hbm that is, the board-side of the inference can be reasoned that the model file:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"./model_output"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ..."})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_calibrated_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed.hbm"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_optimized_float_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_original_float_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_ptq_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 resnet18_224x224_rgb_removed_quantized_model.bc"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsxs)(e.h3,{id:"ptq-api",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#ptq-api",children:"#"}),"PTQ API"]}),"\n",(0,r.jsx)(e.p,{children:"Command line tool provides high ease of use but also bring some flexibility reduction, therefore, when you have the flexibility needs, you can use the PTQ API way to complete the quantization compilation of the model,\nthe following for you to introduce the use of the API way to generate the specific process of the board-side of the model."}),"\n",(0,r.jsxs)(e.div,{className:"rspress-directive warning",children:[(0,r.jsx)(e.div,{className:"rspress-directive-title",children:"Attention"}),(0,r.jsx)(e.div,{className:"rspress-directive-content",children:(0,r.jsxs)(e.p,{children:["Please note that due to the large number of parameters in some interfaces, only the necessary parameters are configured in the sample below to facilitate your overall practice verification,\nplease refer to ",(0,r.jsx)(e.a,{href:"/latest/en/guide/advanced_content/hmct_api_reference/load_model.html",children:"HMCT API Refernence"})," and ",(0,r.jsx)(e.a,{href:"/latest/en/guide/advanced_content/hbdk_api_reference.html",children:"HBDK Tool API Reference"})," for the full parameters of specific interfaces."]})})]}),"\n",(0,r.jsxs)(e.h4,{id:"model-optimized-calibration",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-optimized-calibration",children:"#"}),"Model Optimized Calibration"]}),"\n",(0,r.jsx)(e.p,{children:"First, graph optimization and calibration quantization are performed on the floating-point model, a process for which we use the HMCT API, as exemplified below:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:'title="calibration.py"',children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" logging"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hmct"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"api "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" build_model"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"logging"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"basicConfig"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(level"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"logging.INFO)"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"march "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"nash"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"onnx_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./resnet18.onnx"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cali_data_dir "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./calibration_data_rgb"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model_name "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"resnet18_224x224_rgb_removed"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"working_dir "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./model_output/"'})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cali_data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" []"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cali_data_name "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"listdir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(cali_data_dir):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    data_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(cali_data_dir, cali_data_name)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    cali_data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"append"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"load"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data_path))"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ptq_params "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'cali_dict'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'calibration_data'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'input'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cali_data"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"},"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'debug_methods'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" []"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'output_nodes'"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" []"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"not"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"exists"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(working_dir):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"mkdir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(working_dir)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"build_model"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(onnx_file"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"onnx_path,"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            march"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"march,"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            name_prefix"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"working_dir "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" model_name,"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"**"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"ptq_params)"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.p,{children:["After ",(0,r.jsx)(e.code,{children:"build_model"})," is executed correctly, the ONNX model for each phase will be generated in the ",(0,r.jsx)(e.code,{children:"working_dir"})," directory, which has the following directory structure:"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"./model_output"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_calibrated_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_optimized_float_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_original_float_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_ptq_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 resnet18_224x224_rgb_removed_quant_info.json"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsxs)(e.p,{children:["The *ptq_model.onnx file here is the ONNX model file after the graph optimization and calibration process.\nFor a specific description of the ONNX model in the intermediate stages, please refer to the section Post-Training Quantization(PTQ) - PTQ Conversion Steps - Model Quantization and Compilation - ",(0,r.jsx)(e.a,{href:"/latest/en/guide/ptq/ptq_usage/quantize_compile.html#conversion_output",children:"Interpret Conversion Output"}),"."]}),"\n",(0,r.jsxs)(e.h4,{id:"model-turning-fixed-point-and-compilation",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-turning-fixed-point-and-compilation",children:"#"}),"Model Turning Fixed Point and Compilation"]}),"\n",(0,r.jsx)(e.p,{children:"Next, we need to complete the PTQ model to fixed-point model and model compilation operation, this process we need to complete through the compiler's API, the sample is as follows:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:'title="compile.py"',children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" onnx"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hbdk4"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"compiler"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"onnx "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" export"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hbdk4"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"compiler "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" convert"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"compile"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"march "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"nash-e"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"working_dir "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./model_output/"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model_name "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"resnet18_224x224_rgb_removed"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ptq_onnx_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./model_output/resnet18_224x224_rgb_removed_ptq_model.onnx"'})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"not"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"exists"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(working_dir):"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    os"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"mkdir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(working_dir)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ptq_onnx "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" onnx"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"load"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(ptq_onnx_path)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ptq_model "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"export"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(proto"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"ptq_onnx, name"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model_name)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantized_model "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"convert"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(m"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"ptq_model, march"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"march)"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantized_model"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"functions"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"remove_io_op"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(op_types"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Dequantize"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"])"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"compile"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(m"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"quantized_model,"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"working_dir "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" model_name "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'".hbm"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        march"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"march,"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        progress_bar"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsx)(e.p,{children:"After compilation, the working_dir directory will hold the intermediate stage and final model files that can be used on the board, with the following directory structure:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"./model_output"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_calibrated_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed.hbm"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_optimized_float_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_original_float_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed_ptq_model.onnx"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 resnet18_224x224_rgb_removed_quant_info.json"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsxs)(e.h3,{id:"visualization",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#visualization",children:"#"}),"Visualization"]}),"\n",(0,r.jsxs)(e.p,{children:["After generating the required hbm model, we support you to view it visually with the ",(0,r.jsx)(e.code,{children:"hb_model_info"})," and ",(0,r.jsx)(e.code,{children:"hrt_model_exec"})," tools with the following reference commands:"]}),"\n",(0,r.jsxs)(e.ul,{children:["\n",(0,r.jsxs)(e.li,{children:["Using the ",(0,r.jsx)(e.code,{children:"hb_model_info"})]}),"\n"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hb_model_info"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-v"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"resnet18_224x224_rgb_removed.hbm"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.ul,{children:["\n",(0,r.jsxs)(e.li,{children:["Using the ",(0,r.jsx)(e.code,{children:"hrt_model_exec"})]}),"\n"]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hrt_model_exec"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"model_info"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--model_file"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"resnet18_224x224_rgb_removed.hbm"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.h2,{id:"board_sample",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#board_sample",children:"#"}),"Building Board-side Sample"]}),"\n",(0,r.jsxs)(e.ol,{children:["\n",(0,r.jsx)(e.li,{children:"Dependency libraries for preparing board-side sample."}),"\n"]}),"\n",(0,r.jsxs)(e.p,{children:["To build the boardside sample as quickly as possible, we recommend that you use ",(0,r.jsx)(e.code,{children:"samples/ucp_tutorial/deps_aarch64"})," directly from the OE package."]}),"\n",(0,r.jsx)(e.p,{children:"Directory as dependent libraries, and the key header files and dynamic libraries that the board-side running sample depends on are listed below:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"./deps_aarch64"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 ......"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 ucp"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u251C\u2500\u2500 include"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502   \u2514\u2500\u2500 hobot"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u251C\u2500\u2500 dnn"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u2502   \u251C\u2500\u2500 hb_dnn.h"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u2502   \u251C\u2500\u2500 hb_dnn_status.h"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u2502   \u2514\u2500\u2500 hb_dnn_v1.h"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u251C\u2500\u2500 ......"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u251C\u2500\u2500 hb_sys.h"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u251C\u2500\u2500 hb_ucp.h"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u251C\u2500\u2500 hb_ucp_status.h"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2502       \u2514\u2500\u2500 hb_ucp_sys.h"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2514\u2500\u2500 lib"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        \u251C\u2500\u2500 ......"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        \u251C\u2500\u2500 libdnn.so"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        \u2514\u2500\u2500 libhbucp.so"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsxs)(e.ol,{start:"2",children:["\n",(0,r.jsx)(e.li,{children:"Board-side sample development"}),"\n"]}),"\n",(0,r.jsx)(e.p,{children:"The following sample shows the process of completing one board-side model inference and obtaining the classification result TOP1 based on the binary file input and the board-side model."}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-cpp",meta:'title="main.cc"',children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<fstream>"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<iostream>"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<vector>"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"<cstring>"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/dnn/hb_dnn.h"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hb_ucp.h"'})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hb_ucp_sys.h"'})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"const"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"char*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hbm_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"resnet18_224x224_rgb_removed.hbm"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"string data_path "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input.bin"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// Read binary input file"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"read_binary_file"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"string"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" file_path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"char"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"**"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"bin"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"length) {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ifstream "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"ifs"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(file_path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ios"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"in "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"|"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ios"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"binary);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"ifs"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"seekg"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ios"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"end);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"length "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"ifs"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"tellg"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"();"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"ifs"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"seekg"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ios"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"beg);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"bin "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"new"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"char"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"sizeof"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"char"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:") "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"length)];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"ifs"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"read"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"bin"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"length);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"ifs"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"close"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"();"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"main"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"() {"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Get model handle"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"hbDNNPackedHandle_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" packed_dnn_handle;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"hbDNNHandle_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNInitializeFromFiles"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"packed_dnn_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"hbm_path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"const"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"char"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"**"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model_name_list;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" model_count "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetModelNameList"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model_name_list"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model_count"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" packed_dnn_handle);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetModelHandle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dnn_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" packed_dnn_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"model_name_list"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"]);"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Prepare input and output tensor"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"vector"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"hbDNNTensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_tensors;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"vector"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"hbDNNTensor"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" output_tensors;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensors"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"   // This model has only one input"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output_tensors"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"resize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // This model has only one output"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Initialize and malloc the input tensor"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  hbDNNTensor input "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input_tensors"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetInputTensorProperties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_memSize "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"alignedByteSize;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMallocCached"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" input_memSize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Initialize and malloc the output tensor"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  hbDNNTensor output "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output_tensors"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNGetOutputTensorProperties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" output_memSize "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"alignedByteSize;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMallocCached"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" output_memSize"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Copy binary input data to input tensor"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" data_length "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"char"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"nullptr"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"auto"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ret "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"read_binary_file"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(data_path"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"data_length);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"memcpy"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"reinterpret_cast<char"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*>"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"virAddr)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"         data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"memSize);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMemFlush"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem)"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_SYS_MEM_CACHE_CLEAN);"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Submit task and wait till it completed"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"hbUCPTaskHandle_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" task_handle{"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"nullptr"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"};"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbDNNInferV2"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"task_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"input"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dnn_handle);"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  hbUCPSchedParam ctrl_param;"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"HB_UCP_INITIALIZE_SCHED_PARAM"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ctrl_param);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"ctrl_param"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"backend "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_UCP_BPU_CORE_ANY;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPSubmitTask"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ctrl_param);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPWaitTaskDone"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"  // Parse inference result and calculate TOP1"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMemFlush"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_SYS_MEM_CACHE_INVALIDATE);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"auto"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" result "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"reinterpret_cast<int32_t"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*>"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"sysMem"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"virAddr);"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"float"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" scale "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"output"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"properties"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"scale"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"scaleData["}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"];"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"float"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" max_score "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" label "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"auto"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; i "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1000"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; i"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"++"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:") {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"float"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" score "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"result"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"[i] "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" scale;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" (score "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:">"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" max_score) {"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"      label "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" i;"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"      max_score "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" score;"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    }"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  }"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cout "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"label: "'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" label "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"<<"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" std"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"::"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"endl;"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n",(0,r.jsxs)(e.ol,{start:"3",children:["\n",(0,r.jsx)(e.li,{children:"Cross-compile to generate board-side executable program"}),"\n"]}),"\n",(0,r.jsxs)(e.p,{children:["Before cross-compiling, you need to prepare CMakeLists.txt and the sample files.\nCMakeLists.txt content is as follows, because the sample does not contain data preprocessing and other operations, so there are fewer dependencies,\nhere is mainly on the compilation parameters of GCC, dependent header files and dynamic library configuration.\nWhere dnn board-side inference library and ",(0,r.jsx)(e.code,{children:"hbucp"})," is used to do operations on tensor."]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:'title="CMakeLists.txt"',children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"# CMakeLists.txt"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"cmake_minimum_required(VERSION 3.0)"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"project(sample)"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:'set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11 -Wl,-unresolved-symbols=ignore-in-shared-libs")'})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:'message(STATUS "Build type: ${CMAKE_BUILD_TYPE}")'})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:'set(CMAKE_CXX_FLAGS_DEBUG "-g -O0")'})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:'set(CMAKE_C_FLAGS_DEBUG "-g -O0")'})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:'set(CMAKE_CXX_FLAGS_RELEASE " -O3 ")'})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:'set(CMAKE_C_FLAGS_RELEASE " -O3 ")'})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"set(CMAKE_BUILD_TYPE ${build_type})"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"set(DEPS_ROOT ${CMAKE_CURRENT_SOURCE_DIR}/deps_aarch64)"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"include_directories(${DEPS_ROOT}/ucp/include)"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"link_directories(${DEPS_ROOT}/ucp/lib)"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"add_executable(run_sample src/main.cc)"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"target_link_libraries(run_sample dnn hbucp)"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsx)(e.p,{children:"The environment directory structure for compilation is as follows:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"."})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 CMakeLists.txt"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 deps_aarch64"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2514\u2500\u2500 ucp"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502       \u251C\u2500\u2500 include"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502       \u2514\u2500\u2500 lib"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 src"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    \u2514\u2500\u2500 main.cc"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsx)(e.p,{children:"When the sample files and CMakeLists.txt are ready, you can compile them. A sample of the compile command is shown below:"}),"\n",(0,r.jsxs)(e.div,{className:"rspress-directive warning",children:[(0,r.jsx)(e.div,{className:"rspress-directive-title",children:"Attention"}),(0,r.jsx)(e.div,{className:"rspress-directive-content",children:(0,r.jsx)(e.p,{children:"Note that the compilation scripts have to be configured with CC and CXX as the actual paths to cross-compile GCC and G++."})})]}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"#!/usr/bin/env bash"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Note\uFF0Cplease configure according to the actual path"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"export"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" CC"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"/arm-gnu-toolchain-12.2.rel1-x86_64-aarch64-none-linux-gnu/bin/aarch64-none-linux-gnu-gcc"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"export"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" CXX"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"/arm-gnu-toolchain-12.2.rel1-x86_64-aarch64-none-linux-gnu/bin/aarch64-none-linux-gnu-g++"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"rm"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-rf"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"arm_build"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"mkdir"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"arm_build"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"arm_build"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cmake"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:".."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"; "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"make"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-j8"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:".."})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.p,{children:["Once compiled, the board-ready ",(0,r.jsx)(e.code,{children:"run_sample"})," binary program is generated. At this point, the board-side sample build process is complete."]}),"\n",(0,r.jsxs)(e.h2,{id:"preparation-for-board-side-operation",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#preparation-for-board-side-operation",children:"#"}),"Preparation for Board-side Operation"]}),"\n",(0,r.jsx)(e.p,{children:"When the executable program is compiled, the inputs to the model need to be prepared.\nSince the scene calibration set for this hands-on tutorial can be used as model input, we can just use the calibration set data directly as model input here.\nOf course, you can also modify the board-side program according to the pre-processing logic of the calibration set and give it to the model input (this process should be noted that the modified program needs to ensure that the same pre-processing of the original image has been done as in the calibration)."}),"\n",(0,r.jsx)(e.p,{children:"Here we simply convert the calibration set in npy format to a binary file, as shown in the following sample:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-python",meta:'title="input_data.py"',children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number"}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"data "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" np"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"load"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"calibration_data_rgb/ILSVRC2012_val_00000001.npy"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"data"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"tofile"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"input.bin"'}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n"]})})}),"\n",(0,r.jsx)(e.p,{children:"After completing the preparation of the model input data, which means correctly generating the input file in binary format for the board-side sample inference,\nyou also need to make sure that you now have the following ready:"}),"\n",(0,r.jsxs)(e.ul,{children:["\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsx)(e.p,{children:"S100 dev board for the actual execution of board-side program runs."}),"\n"]}),"\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsxs)(e.p,{children:["The model(*.hbm) that can be used for board-side inference, the output of ",(0,r.jsx)(e.a,{href:"#board_model",children:"Generate Board-side Model"}),"."]}),"\n"]}),"\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsxs)(e.p,{children:["The board-side program(main.cc file and cross-compile to generate board-side executable program), the output of ",(0,r.jsx)(e.a,{href:"#board_sample",children:"Building Board-side Sample"}),"."]}),"\n"]}),"\n",(0,r.jsxs)(e.li,{children:["\n",(0,r.jsxs)(e.p,{children:["The board-side program depends on libraries, and in order to reduce deployment costs, you can directly use the contents of the OE package ",(0,r.jsx)(e.code,{children:"samples/ucp_tutorial/deps_aarch64/ucp/lib"})," folder."]}),"\n"]}),"\n"]}),"\n",(0,r.jsx)(e.p,{children:"Once ready, we integrate the model file(*.hbm), input data (*.bin file), board-side program and dependent libraries as above, with the following reference directory structure:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-text",meta:"",children:[(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"horizon"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 input.bin"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 lib"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 resnet18_224x224_rgb_removed.hbm"})}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"\u2514\u2500\u2500 run_sample"})}),"\n",(0,r.jsx)(e.span,{className:"line",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,r.jsx)(e.p,{children:"Copy this integrated folder as a whole to the board-side environment, refer to the following command:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"scp"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-r"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"horizon/"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"root@{board_ip}:/map/"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.h2,{id:"board-side-execution",children:[(0,r.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#board-side-execution",children:"#"}),"Board-side Execution"]}),"\n",(0,r.jsx)(e.p,{children:"Finally, you can configure LD_LIBRARY_PATH and run the program as follows:"}),"\n",(0,r.jsx)(e.pre,{className:"code",children:(0,r.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,r.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"horizon@hobot:/map/horizon#"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"export"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"LD_LIBRARY_PATH=./lib:"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"$LD_LIBRARY_PATH"})]}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"horizon@hobot:/map/horizon#"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"./run_sample"})]}),"\n",(0,r.jsx)(e.span,{className:"line line-number",children:(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"......"})}),"\n",(0,r.jsxs)(e.span,{className:"line line-number",children:[(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"label:"}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,r.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"65"})]}),"\n"]})})}),"\n",(0,r.jsxs)(e.p,{children:["As you can see, the ",(0,r.jsx)(e.code,{children:"label: 65"})," printed in the log is exactly the label corresponding to the ILSVRC2012_val_00000001 image in the ImageNet dataset, i.e., the classification result is correct."]}),"\n",(0,r.jsx)(e.p,{children:"This concludes the full process of practicing the PTQ deployment of removing dequantize node with the ResNet18 model with RGB input."})]})}function o(){let s=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:e}=Object.assign({},(0,l.ah)(),s.components);return e?(0,r.jsx)(e,Object.assign({},s,{children:(0,r.jsx)(i,s)})):i(s)}e.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fmodel_deployment_guidance%2Fmodel_deployment_guidance_examples%2Frgb_remove_resnet18_deployment_guidance.mdx"]={toc:[{id:"prepare-the-floating-point-model",text:"Prepare the Floating Point Model",depth:2},{id:"calibration-set-preparation",text:"Calibration Set Preparation",depth:2},{id:"board_model",text:"Generate Board-side Model",depth:2},{id:"command-line-tool",text:"Command-line Tool",depth:3},{id:"ptq-api",text:"PTQ API",depth:3},{id:"model-optimized-calibration",text:"Model Optimized Calibration",depth:4},{id:"model-turning-fixed-point-and-compilation",text:"Model Turning Fixed Point and Compilation",depth:4},{id:"visualization",text:"Visualization",depth:3},{id:"board_sample",text:"Building Board-side Sample",depth:2},{id:"preparation-for-board-side-operation",text:"Preparation for Board-side Operation",depth:2},{id:"board-side-execution",text:"Board-side Execution",depth:2}],title:"The Practical Guide to Deploying ResNet18 Model with Dequantize Nodes Removed",frontmatter:{}}}}]);